/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationStore;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class CachingTrustedApplicationStore
implements TrustedApplicationStore,
Startable {
    private final TrustedApplicationStore delegate;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Cache> cache = new ResettableLazyReference<Cache>(){

        protected Cache create() throws Exception {
            return new Cache(CachingTrustedApplicationStore.this.delegate.getAll());
        }
    };

    public CachingTrustedApplicationStore(TrustedApplicationStore delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public Set<TrustedApplicationData> getAll() {
        return ((Cache)this.cache.get()).getAll();
    }

    @Override
    public TrustedApplicationData getByApplicationId(String applicationId) {
        return ((Cache)this.cache.get()).get(applicationId);
    }

    @Override
    public TrustedApplicationData getById(long id) {
        return ((Cache)this.cache.get()).get(id);
    }

    @Override
    public TrustedApplicationData store(TrustedApplicationData trustedApplicationData) {
        TrustedApplicationData result = this.delegate.store(trustedApplicationData);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(long id) {
        boolean result = this.delegate.delete(id);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(String applicationId) {
        boolean result = this.delegate.delete(applicationId);
        this.cache.reset();
        return result;
    }

    private static final class Cache {
        final Map<Long, TrustedApplicationData> byId;
        final Map<String, TrustedApplicationData> byAppId;

        Cache(Set<TrustedApplicationData> datas) {
            HashMap<Long, TrustedApplicationData> byId = new HashMap<Long, TrustedApplicationData>(datas.size());
            HashMap<String, TrustedApplicationData> byAppId = new HashMap<String, TrustedApplicationData>(datas.size());
            for (TrustedApplicationData data : datas) {
                byId.put(data.getId(), data);
                byAppId.put(data.getApplicationId(), data);
            }
            this.byId = Collections.unmodifiableMap(byId);
            this.byAppId = Collections.unmodifiableMap(byAppId);
        }

        TrustedApplicationData get(long id) {
            return this.byId.get(id);
        }

        TrustedApplicationData get(String applicationId) {
            return this.byAppId.get(applicationId);
        }

        Set<TrustedApplicationData> getAll() {
            return ImmutableSet.copyOf(this.byId.values());
        }
    }
}

