/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.mapper;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.scheme.mapper.GroupToRoleMapping;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RoleToGroupsMapping {
    private GroupToRoleMapping groupToRoleMapping;
    private Set mappedGroup;

    public RoleToGroupsMapping(GroupToRoleMapping groupToRoleMapping) {
        this.groupToRoleMapping = groupToRoleMapping;
        this.mappedGroup = new HashSet();
    }

    public ProjectRole getProjectRole() {
        return this.groupToRoleMapping.getProjectRole();
    }

    public void addMappedGroup(Group group) {
        this.mappedGroup.add(group);
    }

    public GroupToRoleMapping getGroupToRoleMapping() {
        return this.groupToRoleMapping;
    }

    public Collection getMappedGroups() {
        return this.mappedGroup;
    }

    public Collection getMappedGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : this.mappedGroup) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public Collection getUnpackedUsers() {
        GroupManager groupManager = ComponentManager.getComponent(GroupManager.class);
        HashSet unpackedUsers = new HashSet();
        for (Group group : this.mappedGroup) {
            Collection users = groupManager.getUserNamesInGroup(group);
            if (users == null) continue;
            unpackedUsers.addAll(users);
        }
        return unpackedUsers;
    }

    public Collection getUnpackedUsersLimited(int limit) {
        ArrayList unpackedUsers = new ArrayList(this.getUnpackedUsers());
        if (limit > unpackedUsers.size()) {
            return unpackedUsers;
        }
        return unpackedUsers.subList(0, limit);
    }
}

