/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeTypeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeComparator;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSchemeManager
implements SchemeManager {
    private static final Logger log = Logger.getLogger(AbstractSchemeManager.class);
    private final ConcurrentMap<Long, ConcurrentMap<String, List<GenericValue>>> projectSchemeCache = new ConcurrentHashMap<Long, ConcurrentMap<String, List<GenericValue>>>();
    protected final ProjectManager projectManager;
    private final AbstractSchemeTypeManager typeManager;
    private final PermissionContextFactory permissionContextFactory;
    protected final SchemeFactory schemeFactory;
    private AssociationManager associationManager;
    private OfBizDelegator ofBizDelegator;
    private final GroupManager groupManager;

    protected AbstractSchemeManager(ProjectManager projectManager, AbstractSchemeTypeManager typeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, AssociationManager associationManager, OfBizDelegator ofBizDelegator, GroupManager groupManager) {
        this.projectManager = projectManager;
        this.typeManager = typeManager;
        this.permissionContextFactory = permissionContextFactory;
        this.schemeFactory = schemeFactory;
        this.associationManager = associationManager;
        this.ofBizDelegator = ofBizDelegator;
        this.groupManager = groupManager;
    }

    public void onClearCache(ClearCacheEvent event) {
        this.flushProjectSchemes();
    }

    public abstract String getSchemeEntityName();

    public abstract String getEntityName();

    public abstract String getSchemeDesc();

    public abstract String getDefaultNameKey();

    public abstract String getDefaultDescriptionKey();

    @Deprecated
    public String getAssociationType() {
        return "ProjectScheme";
    }

    public abstract GenericValue copySchemeEntity(GenericValue var1, GenericValue var2) throws GenericEntityException;

    public GenericValue getScheme(Long id) throws GenericEntityException {
        return this.ofBizDelegator.findByPrimaryKey(this.getSchemeEntityName(), EasyMap.build((Object)"id", (Object)id));
    }

    public Scheme getSchemeObject(Long id) throws DataAccessException {
        return this.getSchemeObject(EasyMap.build((Object)"id", (Object)id));
    }

    public Scheme getSchemeObject(String name) throws DataAccessException {
        return this.getSchemeObject(EasyMap.build((Object)"name", (Object)name));
    }

    private Scheme getSchemeObject(Map gvParams) {
        GenericValue schemeGv = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(this.getSchemeEntityName(), gvParams));
        if (schemeGv != null) {
            return this.schemeFactory.getScheme(schemeGv);
        }
        return null;
    }

    public GenericValue getScheme(String name) throws DataAccessException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(this.getSchemeEntityName(), EasyMap.build((Object)"name", (Object)name)));
    }

    public List<GenericValue> getSchemes() throws DataAccessException {
        List schemes = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemes, OfBizComparators.NAME_COMPARATOR);
        return schemes;
    }

    public List<Scheme> getSchemeObjects() throws DataAccessException {
        List schemeGvs = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemeGvs, OfBizComparators.NAME_COMPARATOR);
        return this.schemeFactory.getSchemes(schemeGvs);
    }

    public List<Scheme> getAssociatedSchemes(boolean withEntitiesComparable) throws DataAccessException {
        ArrayList<Scheme> associatedSchemes = new ArrayList<Scheme>();
        try {
            List<GenericValue> schemes = this.getSchemes();
            for (GenericValue schemeGV : schemes) {
                if (this.getProjects(schemeGV).size() == 0) continue;
                if (withEntitiesComparable) {
                    associatedSchemes.add(this.schemeFactory.getSchemeWithEntitiesComparable(schemeGV));
                    continue;
                }
                associatedSchemes.add(this.schemeFactory.getScheme(schemeGV));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        return associatedSchemes;
    }

    public List<Scheme> getUnassociatedSchemes() throws DataAccessException {
        ArrayList<Scheme> unassociatedSchemes = new ArrayList<Scheme>();
        try {
            List<GenericValue> schemes = this.getSchemes();
            for (GenericValue schemeGV : schemes) {
                if (!this.getProjects(schemeGV).isEmpty()) continue;
                unassociatedSchemes.add(this.schemeFactory.getScheme(schemeGV));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(unassociatedSchemes, new SchemeComparator());
        return unassociatedSchemes;
    }

    public List<GenericValue> getSchemes(GenericValue project) throws GenericEntityException {
        if (project == null) {
            throw new IllegalArgumentException("Cannot get schemes for null project");
        }
        return this.cacheAndReturnProjectSchemes(project, this.getSchemeEntityName());
    }

    public Scheme getSchemeFor(Project project) {
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            if (schemes.isEmpty()) {
                return null;
            }
            if (schemes.size() > 1) {
                throw new IllegalStateException("Too many " + this.getSchemeEntityName() + " schemes found for Project " + project.getKey());
            }
            return this.schemeFactory.getScheme(schemes.iterator().next());
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    public GenericValue getEntity(Long id) throws GenericEntityException {
        return this.ofBizDelegator.findByPrimaryKey(this.getEntityName(), EasyMap.build((Object)"id", (Object)id));
    }

    public List<GenericValue> getEntities(String type, String parameter) throws GenericEntityException {
        List result = this.ofBizDelegator.findByAnd(this.getEntityName(), EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        return result;
    }

    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        List related = scheme.getRelated("Child" + this.getEntityName());
        return related;
    }

    public boolean schemeExists(String name) throws GenericEntityException {
        return this.getScheme(name) != null;
    }

    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        if (!this.schemeExists(name)) {
            this.flushProjectSchemes();
            return this.createSchemeGenericValue(EasyMap.build((Object)"name", (Object)name, (Object)"description", (Object)description));
        }
        throw new GenericEntityException("Could not create " + this.getSchemeDesc() + " Scheme with name:" + name + " as it already exists.");
    }

    public Scheme createSchemeObject(String name, String description) {
        try {
            return this.schemeFactory.getScheme(this.createScheme(name, description));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Scheme createSchemeAndEntities(Scheme scheme) throws DataAccessException {
        GenericValue schemeGV;
        if (scheme == null) {
            throw new IllegalArgumentException();
        }
        try {
            schemeGV = this.createScheme(scheme.getName(), scheme.getDescription());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        ArrayList<GenericValue> entityGVs = new ArrayList<GenericValue>();
        Collection schemeEntities = scheme.getEntities();
        for (SchemeEntity schemeEntity : schemeEntities) {
            try {
                entityGVs.add(this.createSchemeEntity(schemeGV, schemeEntity));
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        return this.schemeFactory.getScheme(schemeGV, entityGVs);
    }

    public void updateScheme(GenericValue entity) throws GenericEntityException {
        entity.store();
        this.flushProjectSchemes();
    }

    public void updateScheme(Scheme scheme) throws DataAccessException {
        try {
            GenericValue schemeEntity = this.getScheme(scheme.getId());
            schemeEntity.setString("name", scheme.getName());
            schemeEntity.setString("description", scheme.getDescription());
            this.updateScheme(schemeEntity);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteScheme(Long id) throws GenericEntityException {
        if (id != null && id != 0L) {
            GenericValue scheme = this.getScheme(id);
            this.associationManager.removeAssociationsFromSink(scheme);
            scheme.removeRelated("Child" + this.getEntityName());
            scheme.remove();
            this.flushProjectSchemes();
        }
    }

    @Deprecated
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        if (project == null) {
            throw new IllegalArgumentException("The project passed can not be null.");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("The first argument passed must be a project, " + project.getEntityName() + " is not.");
        }
        List<GenericValue> schemes = this.getSchemes(project);
        if (!schemes.contains(scheme)) {
            this.associationManager.createAssociation(project, scheme, this.getAssociationType());
        }
        this.flushProjectSchemes();
    }

    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        if (project == null) {
            throw new IllegalArgumentException("The project passed can not be null.");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("The sheme passed can not be null.");
        }
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            GenericValue schemeGV = this.getScheme(scheme.getId());
            if (!schemes.contains(schemeGV)) {
                this.associationManager.createAssociation(project.getGenericValue(), schemeGV, this.getAssociationType());
            }
            this.flushProjectSchemes();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void removeSchemesFromProject(Project project) throws DataAccessException {
        try {
            this.removeSchemesFromProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Deprecated
    public void removeSchemesFromProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes = this.getSchemes(project);
        for (GenericValue scheme : schemes) {
            this.associationManager.removeAssociation(project, scheme, this.getAssociationType());
        }
        this.flushProjectSchemes();
    }

    public void deleteEntity(Long id) throws DataAccessException {
        try {
            this.getEntity(id).remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Deprecated
    public List<GenericValue> getProjects(GenericValue scheme) throws GenericEntityException {
        List<Long> projectIds = this.associationManager.getSourceIdsFromSink(scheme, "Project", this.getAssociationType());
        ArrayList<GenericValue> projects = new ArrayList<GenericValue>();
        for (Long projectId : projectIds) {
            projects.add(this.projectManager.getProject(projectId));
        }
        Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    public List<Project> getProjects(Scheme scheme) throws DataAccessException {
        if (scheme == null || scheme.getId() == null) {
            throw new IllegalArgumentException("The scheme and the schemes id can not be null");
        }
        try {
            GenericValue schemeGV = this.getScheme(scheme.getId());
            return new ArrayList<Project>(ComponentManager.getInstance().getProjectFactory().getProjects(this.getProjects(schemeGV)));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue createDefaultScheme() throws GenericEntityException {
        if (this.getDefaultScheme() == null) {
            return this.createSchemeGenericValue(EasyMap.build((Object)"id", (Object)0L, (Object)"name", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultNameKey(), "Default " + this.getSchemeDesc() + " Scheme"), (Object)"description", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultDescriptionKey(), "This is the default " + this.getSchemeDesc() + " Scheme. Any new projects that are created will be assigned this scheme")));
        }
        return this.getDefaultScheme();
    }

    public boolean removeEntities(String type, String parameter) throws RemoveException {
        if (type == null) {
            throw new IllegalArgumentException("Type passed must not be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter passed must not be null");
        }
        try {
            List<GenericValue> entities = this.getEntities(type, parameter);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed to this function must not be NULL");
        }
        try {
            List entities = this.getEntities(scheme, entityTypeId);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public GenericValue getDefaultScheme() throws GenericEntityException {
        return this.ofBizDelegator.findByPrimaryKey(this.getSchemeEntityName(), EasyMap.build((Object)"id", (Object)new Long(0L)));
    }

    public Scheme getDefaultSchemeObject() {
        try {
            GenericValue defaultSchemeGV = this.getDefaultScheme();
            if (defaultSchemeGV == null) {
                return null;
            }
            return this.schemeFactory.getScheme(defaultSchemeGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void addDefaultSchemeToProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes;
        GenericValue scheme = this.getDefaultScheme();
        if (scheme != null && !(schemes = this.getSchemes(project)).contains(scheme)) {
            this.associationManager.createAssociation(project, scheme, this.getAssociationType());
        }
        this.flushProjectSchemes();
    }

    public void addDefaultSchemeToProject(Project project) throws DataAccessException {
        try {
            this.addDefaultSchemeToProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue copyScheme(GenericValue scheme) throws GenericEntityException {
        if (scheme == null) {
            return null;
        }
        String name = ComponentManager.getInstance().getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", scheme.getString("name"));
        int j = 2;
        while (this.schemeExists(name)) {
            name = ComponentManager.getInstance().getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyxof", String.valueOf(j++), scheme.getString("name"));
        }
        GenericValue newScheme = this.createScheme(name, scheme.getString("description"));
        List<GenericValue> origEntities = this.getEntities(scheme);
        for (GenericValue entity : origEntities) {
            this.copySchemeEntity(newScheme, entity);
        }
        return newScheme;
    }

    public Scheme copyScheme(Scheme scheme) {
        try {
            GenericValue oldScheme = this.getScheme(scheme.getId());
            GenericValue newScheme = this.copyScheme(oldScheme);
            return this.schemeFactory.getScheme(newScheme);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<GenericValue> cacheAndReturnProjectSchemes(GenericValue project, String entityName) throws GenericEntityException {
        Long projectId = project.getLong("id");
        ConcurrentMap projectEntry = (ConcurrentMap)this.projectSchemeCache.get(projectId);
        while (projectEntry == null) {
            this.projectSchemeCache.putIfAbsent(projectId, new ConcurrentHashMap());
            projectEntry = (ConcurrentMap)this.projectSchemeCache.get(projectId);
        }
        if (!projectEntry.containsKey(entityName)) {
            List<GenericValue> sinkFromSource = this.associationManager.getSinkFromSource(project, entityName, this.getAssociationType(), false);
            projectEntry.putIfAbsent(entityName, sinkFromSource);
        }
        return Collections.unmodifiableList((List)projectEntry.get(this.getSchemeEntityName()));
    }

    protected void flushProjectSchemes() {
        this.projectSchemeCache.clear();
    }

    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        return this.getGroups(entityTypeId, project.getGenericValue());
    }

    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed can NOT be null");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("Project passed must be a project not a " + project.getEntityName());
        }
        HashSet<Group> groups = new HashSet<Group>();
        try {
            List<GenericValue> schemes = this.getSchemes(project);
            for (GenericValue scheme : schemes) {
                List entity = this.getEntities(scheme, entityTypeId, "group");
                for (GenericValue permission : entity) {
                    groups.add(this.groupManager.getGroup(permission.getString("parameter")));
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return groups;
    }

    public Collection<User> getUsers(Long permissionId, GenericValue projectOrIssue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(projectOrIssue));
    }

    public Collection<User> getUsers(Long permissionId, Project project) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(project));
    }

    public Collection<User> getUsers(Long permissionId, Issue issue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(issue));
    }

    public Collection<User> getUsers(Long permissionId, PermissionContext ctx) {
        HashSet<User> users = new HashSet<User>();
        Map permTypes = this.typeManager.getTypes();
        try {
            List<GenericValue> schemes = this.getSchemes(ctx.getProject());
            for (GenericValue scheme : schemes) {
                List entities = this.getEntities(scheme, permissionId);
                for (GenericValue entity : entities) {
                    SecurityType secType = (SecurityType)permTypes.get(entity.getString("type"));
                    try {
                        Set<User> usersToAdd = secType.getUsers(ctx, entity.getString("parameter"));
                        users.addAll(usersToAdd);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return users;
    }

    protected GenericValue createSchemeGenericValue(Map<String, Object> values) throws GenericEntityException {
        return EntityUtils.createValue(this.getSchemeEntityName(), values);
    }

    private String getI18nTextWithDefaultNullCheck(String key, String defaultResult) {
        if (key == null) {
            return defaultResult;
        }
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }
}

