/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CanAdministerProjectCondition
implements Condition {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;

    public CanAdministerProjectCondition(PermissionManager permissionManager, JiraAuthenticationContext authContext, ProjectManager projectManager) {
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.projectManager = projectManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        User user = this.authContext.getLoggedInUser();
        Project project = this.getProject(context);
        if (project == null) {
            return false;
        }
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            return this.hasPermission(user, project);
        }
        String cacheKey = "atl.jira.permission.request.cache:23:" + user.getName() + ":" + project.getKey();
        if (request.getAttribute(cacheKey) == null) {
            request.setAttribute(cacheKey, (Object)this.hasPermission(user, project));
        }
        return (Boolean)request.getAttribute(cacheKey);
    }

    private boolean hasPermission(User user, Project project) {
        try {
            return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(23, project, user);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Project getProject(Map<String, Object> context) {
        JiraHelper helper;
        if (context.containsKey("project")) {
            return (Project)context.get("project");
        }
        if (context.containsKey("issue")) {
            return ((Issue)context.get("issue")).getProjectObject();
        }
        if (context.containsKey("helper") && (helper = (JiraHelper)context.get("helper")).getProjectObject() != null) {
            return helper.getProjectObject();
        }
        if (context.containsKey("version")) {
            return ((Version)context.get("version")).getProjectObject();
        }
        if (context.containsKey("component")) {
            Long projectId = ((ProjectComponent)context.get("component")).getProjectId();
            Project project = this.projectManager.getProjectObj(projectId);
            return project;
        }
        return null;
    }
}

