/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.DatabaseField;
import com.atlassian.jira.ofbiz.MissingFieldException;
import com.atlassian.jira.ofbiz.MissingTableException;
import com.atlassian.jira.ofbiz.UnsupportedTypeException;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class FieldSupportValidator {
    private final Map<DatabaseField, Support> map;
    private final String name;

    FieldSupportValidator(String name, Collection<String> unsupportedTypes, Function<String, Function<String, String>> fieldResolver) {
        this(name, new Resolver(unsupportedTypes, fieldResolver));
    }

    FieldSupportValidator(String name, Resolver supportResolver) {
        this.map = new MapMaker().makeComputingMap(Functions.toGoogleFunction((Function)supportResolver));
        this.name = name;
    }

    void checkAll(String table, Iterable<String> fields) {
        for (String field : fields) {
            this.check(table, field);
        }
    }

    void check(String table, String field) {
        DatabaseField key = new DatabaseField(table, field);
        this.map.get(key).check(this.name, key);
    }

    static class Resolver
    implements Function<DatabaseField, Support> {
        private final Set<String> unsupportedTypes;
        private final Function<String, Function<String, String>> fieldTypeResolver;

        public Resolver(Collection<String> unsupportedTypes, Function<String, Function<String, String>> fieldTypeResolver) {
            this.unsupportedTypes = CollectionBuilder.newBuilder().addAll(unsupportedTypes).asSet();
            this.fieldTypeResolver = (Function)Assertions.notNull((String)"fieldTypeResolver", fieldTypeResolver);
        }

        public Support get(@NotNull DatabaseField input) {
            Function entity = (Function)this.fieldTypeResolver.get((Object)input.table());
            if (entity == null) {
                return Support.MISSING_TABLE;
            }
            String fieldType = (String)entity.get((Object)input.field());
            if (fieldType == null) {
                return Support.MISSING_FIELD;
            }
            if (this.unsupportedTypes.contains(fieldType)) {
                return Support.UNSUPPORTED_TYPE;
            }
            return Support.SUPPORTED;
        }
    }

    static enum Support {
        SUPPORTED{

            @Override
            void check(String name, DatabaseField field) {
            }
        }
        ,
        UNSUPPORTED_TYPE{

            @Override
            void check(String name, DatabaseField field) {
                throw new UnsupportedTypeException(name, field);
            }
        }
        ,
        MISSING_TABLE{

            @Override
            void check(String name, DatabaseField field) {
                throw new MissingTableException(name, field);
            }
        }
        ,
        MISSING_FIELD{

            @Override
            void check(String name, DatabaseField field) {
                throw new MissingFieldException(name, field);
            }
        };


        abstract void check(String var1, DatabaseField var2);
    }
}

