/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.TenantReference;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class DefaultOfBizConnectionFactory
implements OfBizConnectionFactory {
    private final TenantReference tenantReference = MultiTenantContext.getTenantReference();
    private final EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();

    @Override
    public Connection getConnection() throws SQLException, DataAccessException {
        try {
            return ConnectionFactory.getConnection((String)this.getDatabaseConfig().getDatasourceName());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public DatasourceInfo getDatasourceInfo() {
        return this.entityConfigUtil.getDatasourceInfo(this.getDatabaseConfig().getDatasourceName());
    }

    @Override
    public String getDelegatorName() {
        return this.getDatabaseConfig().getDelegatorName();
    }

    private DatabaseConfig getDatabaseConfig() {
        return (DatabaseConfig)this.tenantReference.get().getConfig(DatabaseConfig.class);
    }
}

