/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.MailThreadManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MailThreadManagerImpl
implements MailThreadManager {
    private static final Logger log = Logger.getLogger(MailThreadManagerImpl.class);
    private final DelegatorInterface genericDelegator;
    private final IssueManager issueManager;
    private final EventTypeManager eventTypeManager;

    public MailThreadManagerImpl(DelegatorInterface genericDelegator, IssueManager issueManager, EventTypeManager eventTypeManager) {
        this.genericDelegator = genericDelegator;
        this.issueManager = issueManager;
        this.eventTypeManager = eventTypeManager;
    }

    public MailThreadManagerImpl() {
        this((DelegatorInterface)CoreFactory.getGenericDelegator(), ComponentAccessor.getIssueManager(), ComponentAccessor.getEventTypeManager());
    }

    public void createMailThread(String type, Long source, String emailAddress, String messageId) {
        if (messageId == null || messageId.trim().length() <= 0) {
            return;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("type", type);
        fields.put("source", source);
        fields.put("email", emailAddress);
        fields.put("messageid", messageId);
        try {
            EntityUtils.createValue("NotificationInstance", fields);
        }
        catch (GenericEntityException e) {
            log.warn((Object)("Unable to store thread details for email for source '" + source + "' sent to '" + emailAddress + "'."), (Throwable)e);
        }
    }

    public void threadNotificationEmail(Email email, Long issueId) {
        GenericValue notificationGV = null;
        try {
            notificationGV = EntityUtil.getFirst((List)this.genericDelegator.findByAnd("NotificationInstance", EasyMap.build((Object)"source", (Object)issueId, (Object)"type", (Object)NOTIFICATION_ISSUE_CREATED, (Object)"email", (Object)email.getTo()), EasyList.build((Object)"id")));
        }
        catch (GenericEntityException e) {
            log.info((Object)("Couldn't find Notification Instance record for issue " + issueId + ", so can't thread related email"), (Throwable)e);
            return;
        }
        catch (Throwable t) {
            log.warn((Object)("Error retrieving mail thread for issue " + issueId + " to " + email.getTo() + ": " + t.getMessage()), t);
        }
        if (notificationGV == null) {
            log.info((Object)("Couldn't find Notification Instance record for issue " + issueId + ", so can't thread related email"));
            return;
        }
        log.debug((Object)("Adding In-Reply-To: " + notificationGV.getString("messageid")));
        email.setInReplyTo(notificationGV.getString("messageid"));
    }

    public String getThreadType(Long eventTypeId) {
        if (EventType.ISSUE_CREATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_CREATED;
        }
        if (EventType.ISSUE_ASSIGNED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_ASSIGNED;
        }
        if (EventType.ISSUE_RESOLVED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_RESOLVED;
        }
        if (EventType.ISSUE_CLOSED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_CLOSED;
        }
        if (EventType.ISSUE_REOPENED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_REOPENED;
        }
        if (EventType.ISSUE_COMMENTED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_COMMENTED;
        }
        if (EventType.ISSUE_COMMENT_EDITED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_COMMENT_EDITED;
        }
        if (EventType.ISSUE_DELETED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_DELETED;
        }
        if (EventType.ISSUE_UPDATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_UPDATED;
        }
        if (EventType.ISSUE_WORKLOGGED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOGGED;
        }
        if (EventType.ISSUE_WORKLOG_UPDATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOG_UPDATED;
        }
        if (EventType.ISSUE_WORKLOG_DELETED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOG_DELETED;
        }
        if (EventType.ISSUE_WORKSTARTED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKSTARTED;
        }
        if (EventType.ISSUE_WORKSTOPPED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKSTOPPED;
        }
        if (EventType.ISSUE_GENERICEVENT_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_GENERICEVENT;
        }
        if (this.eventTypeManager.isEventTypeExists(eventTypeId)) {
            return "NOTIFICATION_" + eventTypeId;
        }
        throw new IllegalArgumentException("Unable to thread this notification as the event type " + eventTypeId + " is unknown.");
    }

    public GenericValue getAssociatedIssue(Message message) {
        Issue issue = this.getAssociatedIssueObject(message);
        if (issue == null) {
            return null;
        }
        return issue.getGenericValue();
    }

    @Nullable
    public Issue getAssociatedIssueObject(Message message) {
        try {
            String[] messageIds = message.getHeader("In-Reply-To");
            try {
                if (messageIds != null && messageIds.length > 0) {
                    List notificationInstanceGVs;
                    String messageId = messageIds[0];
                    int index = messageId.indexOf(";");
                    if (index > 0) {
                        messageId = messageId.substring(0, index);
                    }
                    if ((notificationInstanceGVs = this.genericDelegator.findByAnd("NotificationInstance", EasyMap.build((Object)"messageid", (Object)messageId))) == null || notificationInstanceGVs.isEmpty()) {
                        log.debug((Object)("Cannot find any associated issues with message id '" + messageId + "'."));
                        return null;
                    }
                    GenericValue notificationInstanceGV = (GenericValue)notificationInstanceGVs.get(0);
                    Long issueId = notificationInstanceGV.getLong("source");
                    return this.issueManager.getIssueObject(issueId);
                }
                log.debug((Object)"No In-Reply-To header found");
                return null;
            }
            catch (GenericEntityException e) {
                log.error((Object)"Error occurred while retrieving Notification Instance records for message.");
                return null;
            }
        }
        catch (MessagingException e) {
            log.error((Object)"Error occurred while determining message id of an e-mail message.", (Throwable)e);
            return null;
        }
    }

    public int removeAssociatedEntries(Long issueId) throws GenericEntityException {
        return this.genericDelegator.removeByAnd("NotificationInstance", EasyMap.build((Object)"source", (Object)issueId));
    }
}

