/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteHistoryStore;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultVoteManager
implements VoteManager {
    private static final Logger log = Logger.getLogger(DefaultVoteManager.class);
    private static final String ASSOCIATION_TYPE = "VoteIssue";
    private final ApplicationProperties applicationProperties;
    private final UserAssociationStore userAssociationStore;
    private final VoteHistoryStore voteHistoryStore;
    private final IssueIndexManager indexManager;

    public DefaultVoteManager(ApplicationProperties applicationProperties, UserAssociationStore userAssociationStore, IssueIndexManager indexManager, VoteHistoryStore voteHistoryStore) {
        this.applicationProperties = applicationProperties;
        this.userAssociationStore = userAssociationStore;
        this.indexManager = indexManager;
        this.voteHistoryStore = voteHistoryStore;
    }

    public boolean addVote(User user, Issue issue) {
        return this.updateVote(true, user, issue.getGenericValue());
    }

    public boolean addVote(User user, GenericValue issue) {
        return this.updateVote(true, user, issue);
    }

    public boolean removeVote(User user, Issue issue) {
        return this.updateVote(false, user, issue.getGenericValue());
    }

    public boolean removeVote(User user, GenericValue issue) {
        return this.updateVote(false, user, issue);
    }

    public Collection<String> getVoterUsernames(Issue issue) {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
    }

    public Collection<String> getVoterUsernames(GenericValue issue) {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue);
    }

    public List<VoteHistoryEntry> getVoteHistory(Issue issue) {
        return this.voteHistoryStore.getHistory(issue.getId());
    }

    public List<User> getVoters(Issue issue, Locale usersLocale) {
        return this.getVoters(issue.getGenericValue(), usersLocale);
    }

    private List<User> getVoters(GenericValue issueGV, Locale usersLocale) {
        List<User> voters = this.userAssociationStore.getUsersFromSink(ASSOCIATION_TYPE, issueGV);
        Collections.sort(voters, new UserBestNameComparator(usersLocale));
        return voters;
    }

    private boolean updateVote(boolean isVoting, User user, GenericValue issue) {
        if (this.validateUpdate(user, issue)) {
            try {
                if (isVoting) {
                    if (!this.hasVoted(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        this.adjustVoteCount(issue, 1);
                        return true;
                    }
                } else if (this.hasVoted(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user, issue);
                    this.adjustVoteCount(issue, -1);
                    return true;
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)"Error changing vote association", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void adjustVoteCount(GenericValue issue, int adjustValue) throws GenericEntityException {
        Long votes = issue.getLong("votes");
        if (votes == null) {
            votes = 0L;
        }
        if ((votes = Long.valueOf(votes + (long)adjustValue)) < 0L) {
            votes = 0L;
        }
        issue.set("votes", (Object)votes);
        issue.store();
        Timestamp now = new Timestamp(new Date().getTime());
        this.voteHistoryStore.add(new VoteHistoryEntryImpl(issue.getLong("id"), now, votes));
        try {
            this.indexManager.reIndex(issue);
        }
        catch (IndexException e) {
            log.error((Object)("Exception re-indexing issue " + (Object)((Object)e)), (Throwable)e);
        }
    }

    private boolean validateUpdate(User user, GenericValue issue) {
        if (issue == null) {
            log.error((Object)"You must specify an issue.");
            return false;
        }
        if (!this.isVotingEnabled()) {
            log.error((Object)("Voting is not enabled - the change vote on issue " + issue.getString("key") + " by user " + user.getName() + " was unsuccessful."));
            return false;
        }
        if (issue.getString("resolution") != null) {
            log.error((Object)"Cannot change vote on issue that has been resolved.");
            return false;
        }
        if (user == null) {
            log.error((Object)"You must specify a user.");
            return false;
        }
        return true;
    }

    public boolean isVotingEnabled() {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    public boolean hasVoted(User user, Issue issue) {
        if (user == null) {
            return false;
        }
        if (issue.getVotes() == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getId());
    }

    public boolean hasVoted(User user, GenericValue issue) {
        if (user == null) {
            return false;
        }
        if (issue.getLong("votes") == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, issue);
    }

    public void removeVotesForUser(User user) {
        Null.not("user", user);
        List<GenericValue> issueGvs = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        for (GenericValue issueGv : issueGvs) {
            this.updateVote(false, user, issueGv);
        }
    }
}

