/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.IssueComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.IssueSortComparator;
import org.apache.lucene.document.Document;

public class DefaultIssueSortComparator
implements IssueSortComparator {
    private final IssueComparator issueComparator;
    private final IssueFactory issueFactory;

    public DefaultIssueSortComparator(IssueComparator issueComparator) {
        this(issueComparator, ComponentManager.getComponentInstanceOfType(IssueFactory.class));
    }

    public DefaultIssueSortComparator(IssueComparator issueComparator, IssueFactory issueFactory) {
        if (issueComparator == null) {
            throw new NullPointerException(this.getClass().getName() + " requires an instance of " + IssueComparator.class.getName());
        }
        this.issueComparator = issueComparator;
        if (issueFactory == null) {
            throw new NullPointerException(this.getClass().getName() + " requires an instance of " + IssueFactory.class.getName());
        }
        this.issueFactory = issueFactory;
    }

    @Override
    public int compare(Issue issue1, Issue issue2) {
        return this.issueComparator.compare(issue1, issue2);
    }

    @Override
    public Issue getIssueFromDocument(Document document) {
        return this.issueFactory.getIssue(document);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIssueSortComparator that = (DefaultIssueSortComparator)o;
        return this.issueComparator != null ? this.issueComparator.equals(that.issueComparator) : that.issueComparator == null;
    }

    public int hashCode() {
        return this.issueComparator != null ? this.issueComparator.hashCode() : 0;
    }
}

