/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class CustomFieldLabelsIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    public static final String FOLDED_EXT = "_folded";

    public CustomFieldLabelsIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
        this.customField = customField;
    }

    public String getDocumentFieldId() {
        return this.customField.getId() + FOLDED_EXT;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addIndex(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addIndex(doc, issue, Field.Index.NO);
    }

    private void addIndex(Document doc, Issue issue, Field.Index index) {
        Set labels = (Set)this.customField.getValue(issue);
        if (labels == null || labels.isEmpty()) {
            if (!index.equals((Object)Field.Index.NO)) {
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), "<EMPTY>", Field.Store.NO, index));
            }
        } else {
            for (Label label : labels) {
                String theLabel = label.getLabel();
                if (!StringUtils.isNotBlank((String)theLabel)) continue;
                doc.add((Fieldable)new Field(this.customField.getId(), theLabel, Field.Store.YES, index));
                if (index.equals((Object)Field.Index.NO)) continue;
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), theLabel.toLowerCase(), Field.Store.NO, index));
            }
        }
    }
}

