/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.AbstractDateRangeBuilder;
import org.apache.log4j.Logger;

public class ReporterDateRangeBuilder
extends AbstractDateRangeBuilder {
    private static final Logger log = Logger.getLogger(ReporterDateRangeBuilder.class);
    private static final String EMPTY_VALUE = "issue_no_reporter";

    public ReporterDateRangeBuilder() {
        this("reporter", EMPTY_VALUE);
    }

    public ReporterDateRangeBuilder(String field, String emptyValue) {
        super(field, emptyValue);
    }

    @Override
    protected ChangeHistoryItem createInitialChangeItem(Issue issue) {
        String reporterName = issue.getReporter() == null ? "" : issue.getReporter().getDisplayName();
        String reporterValue = issue.getReporter() == null ? EMPTY_VALUE : issue.getReporter().getName();
        return new ChangeHistoryItem.Builder().withId(-1L).inChangeGroup(-1L).forIssue(issue.getId().longValue(), issue.getKey()).inProject(issue.getProjectObject().getId().longValue()).field(this.getField()).on(issue.getCreated()).to(reporterName, reporterValue).byUser(issue.getReporter() == null ? EMPTY_VALUE : issue.getReporter().getName()).build();
    }
}

