/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.user.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class ChangeLogUtils {
    private static final Logger log = Logger.getLogger(ChangeLogUtils.class);

    @Deprecated
    public static void deleteChangesForIssue(GenericValue issue) {
        DefaultOfBizDelegator delegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
        Map params = EasyMap.build((Object)"issue", (Object)issue.getLong("id"));
        List changeGroups = delegator.findByAnd("ChangeGroup", params);
        for (GenericValue changeGroup : changeGroups) {
            delegator.removeByAnd("ChangeItem", EasyMap.build((Object)"group", (Object)changeGroup.getLong("id")));
        }
        delegator.removeByAnd("ChangeGroup", params);
    }

    public static GenericValue createChangeGroup(User changeAuthor, GenericValue before, GenericValue after, Collection incomingChangeItems, boolean generateChangeItems) {
        DefaultOfBizDelegator delegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
        if (generateChangeItems && EntityUtils.identical(before, after) && (incomingChangeItems == null || incomingChangeItems.size() == 0)) {
            return null;
        }
        GenericValue changeGroup = null;
        ArrayList changeItems = new ArrayList();
        if (generateChangeItems && !EntityUtils.identical(before, after)) {
            changeItems.addAll(ChangeLogUtils.generateChangeItems(before, after));
        }
        if (incomingChangeItems != null) {
            changeItems.addAll(incomingChangeItems);
        }
        if (!changeItems.isEmpty()) {
            changeGroup = delegator.createValue("ChangeGroup", EasyMap.build((Object)"issue", (Object)before.getLong("id"), (Object)"author", (Object)(changeAuthor != null ? changeAuthor.getName() : null), (Object)"created", (Object)UtilDateTime.nowTimestamp()));
            for (ChangeItemBean cib : changeItems) {
                Map fields = EasyMap.build((Object)"group", (Object)changeGroup.getLong("id"));
                fields.put("fieldtype", cib.getFieldType());
                fields.put("field", cib.getField());
                fields.put("oldvalue", cib.getFrom());
                fields.put("oldstring", cib.getFromString());
                fields.put("newvalue", cib.getTo());
                fields.put("newstring", cib.getToString());
                delegator.createValue("ChangeItem", fields);
            }
        }
        return changeGroup;
    }

    public static GenericValue createChangeGroup(User changeAuthor, Issue before, Issue after, Collection incomingChangeItems, boolean generateChangeItems) {
        return ChangeLogUtils.createChangeGroup(changeAuthor, before.getGenericValue(), after.getGenericValue(), incomingChangeItems, generateChangeItems);
    }

    public static List generateChangeItems(GenericValue before, GenericValue after) {
        ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>();
        for (String fieldname : before.getModelEntity().getAllFieldNames()) {
            ChangeItemBean changeItem;
            if (fieldname.equals("id") || fieldname.equals("created") || fieldname.equals("updated") || fieldname.equals("workflowId") || fieldname.equals("key") || fieldname.equals("project") || fieldname.equals("fixfor") || fieldname.equals("component") || fieldname.equals("votes") || (changeItem = ChangeLogUtils.generateChangeItem(before, after, fieldname)) == null) continue;
            changeItems.add(changeItem);
        }
        return changeItems;
    }

    public static ChangeItemBean generateChangeItem(GenericValue before, GenericValue after, String fieldname) {
        if (before.get(fieldname) == null && after.get(fieldname) == null) {
            return null;
        }
        if (before.get(fieldname) != null && after.get(fieldname) != null && before.get(fieldname).equals(after.get(fieldname))) {
            return null;
        }
        String from = null;
        String to = null;
        String fromString = null;
        String toString = null;
        if (fieldname.equals("assignee") || fieldname.equals("reporter")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                User fromUser = UserUtils.getUser((String)from);
                if (fromUser != null) {
                    fromString = fromUser.getDisplayName();
                } else {
                    log.warn((Object)("User: " + from + " not found - change item will be missing full name."));
                }
            }
            if (to != null) {
                User toUser = UserUtils.getUser((String)to);
                if (toUser != null) {
                    toString = toUser.getDisplayName();
                } else {
                    log.warn((Object)("User: " + to + " not found - change item will be missing full name."));
                }
            }
        } else if (fieldname.equals("type")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ManagerFactory.getConstantsManager().getIssueType(from).getString("name");
            }
            if (to != null) {
                toString = ManagerFactory.getConstantsManager().getIssueType(to).getString("name");
            }
        } else if (fieldname.equals("resolution")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ManagerFactory.getConstantsManager().getResolution(from).getString("name");
            }
            if (to != null) {
                toString = ManagerFactory.getConstantsManager().getResolution(to).getString("name");
            }
        } else if (fieldname.equals("priority")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ManagerFactory.getConstantsManager().getPriorityName(from);
            }
            if (to != null) {
                toString = ManagerFactory.getConstantsManager().getPriorityName(to);
            }
        } else if (fieldname.equals("timeestimate") || fieldname.equals("timespent")) {
            Long fromValue = before.getLong(fieldname);
            Long toValue = after.getLong(fieldname);
            if (fromValue != null) {
                from = fromValue.toString();
                fromString = from = fromValue.toString();
            }
            if (toValue != null) {
                to = toValue.toString();
                toString = toValue.toString();
            }
        } else if (fieldname.equals("status")) {
            GenericValue toStatus;
            GenericValue fromStatus;
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null && (fromStatus = ManagerFactory.getConstantsManager().getStatus(from)) != null) {
                fromString = fromStatus.getString("name");
            }
            if (to != null && (toStatus = ManagerFactory.getConstantsManager().getStatus(to)) != null) {
                toString = toStatus.getString("name");
            }
        } else {
            if (fieldname.equals("security")) {
                from = before.getString(fieldname);
                to = after.getString(fieldname);
                return ChangeLogUtils.generateSecurityChangeItem(fieldname, from, to);
            }
            fromString = before.getString(fieldname);
            toString = after.getString(fieldname);
        }
        return new ChangeItemBean("jira", fieldname, from, fromString, to, toString);
    }

    public static ChangeItemBean generateSecurityChangeItem(String fieldname, String from, String to) {
        String fromString = null;
        String toString = null;
        if (from != null) {
            try {
                GenericValue fromLevel = ManagerFactory.getIssueSecurityLevelManager().getIssueSecurityLevel(new Long(from));
                if (fromLevel != null) {
                    fromString = fromLevel.getString("name");
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (to != null) {
            try {
                GenericValue toLevel = ManagerFactory.getIssueSecurityLevelManager().getIssueSecurityLevel(new Long(to));
                if (toLevel != null) {
                    toString = toLevel.getString("name");
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return new ChangeItemBean("jira", fieldname, from, fromString, to, toString);
    }
}

