/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.fields.renderer.wiki.WikiRendererFactory;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.V2RendererFacade;
import org.springframework.beans.factory.DisposableBean;

public class AtlassianWikiRenderer
implements JiraRendererPlugin,
DisposableBean {
    public static final String ISSUE_CONTEXT_KEY = "jira.issue";
    public static final String RENDERER_TYPE = "atlassian-wiki-renderer";
    private volatile JiraRendererModuleDescriptor jiraRendererModuleDescriptor;
    private final WikiRendererFactory wikiFactory = new WikiRendererFactory();
    private final EventPublisher eventPublisher;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public AtlassianWikiRenderer(EventPublisher eventPublisher, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.eventPublisher = eventPublisher;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.eventPublisher.register((Object)this.wikiFactory);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this.wikiFactory);
    }

    public String render(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToXHtml(this.getRenderContext(context), value);
    }

    public String renderAsText(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToText(this.getRenderContext(context), value);
    }

    public String getRendererType() {
        return RENDERER_TYPE;
    }

    public Object transformForEdit(Object rawValue) {
        return rawValue;
    }

    public Object transformFromEdit(Object editValue) {
        return editValue;
    }

    public void init(JiraRendererModuleDescriptor jiraRendererModuleDescriptor) {
        this.jiraRendererModuleDescriptor = jiraRendererModuleDescriptor;
    }

    public JiraRendererModuleDescriptor getDescriptor() {
        return this.jiraRendererModuleDescriptor;
    }

    private V2RendererFacade getRendererFacade() {
        return this.getWikiRendererFactory().getWikiRenderer();
    }

    RenderContext getRenderContext(IssueRenderContext context) {
        RenderContext renderContext = new RenderContext();
        if (context != null) {
            renderContext.getParams().putAll(context.getParams());
            renderContext.addParam((Object)ISSUE_CONTEXT_KEY, (Object)context.getIssue());
        }
        renderContext.setBaseUrl(this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
        RenderMode allWithNoMacroErrors = RenderMode.suppress((long)16384L);
        renderContext.pushRenderMode(allWithNoMacroErrors);
        return renderContext;
    }

    private WikiRendererFactory getWikiRendererFactory() {
        return this.wikiFactory;
    }
}

