/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersisterImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.cache.JiraCachedManager;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.map.CacheObject;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachedFieldConfigSchemePersister
extends FieldConfigSchemePersisterImpl
implements JiraCachedManager,
Startable {
    private final ConcurrentMap<Long, CacheObject<FieldConfigScheme>> cacheById = new ConcurrentHashMap<Long, CacheObject<FieldConfigScheme>>();
    private final ConcurrentMap<String, CacheObject<List<FieldConfigScheme>>> cacheByCustomField = new ConcurrentHashMap<String, CacheObject<List<FieldConfigScheme>>>();
    private final ConcurrentMap<Long, FieldConfigScheme> cacheByFieldConfigId = new ConcurrentHashMap<Long, FieldConfigScheme>();
    private final EventPublisher eventPublisher;

    public CachedFieldConfigSchemePersister(OfBizDelegator delegator, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, EventPublisher eventPublisher, FieldConfigContextPersister fieldContextPersister) {
        super(delegator, constantsManager, fieldConfigPersister, fieldContextPersister);
        this.eventPublisher = eventPublisher;
        this.init();
    }

    @Override
    public synchronized void init() {
        super.init();
        this.cacheById.clear();
        this.cacheByCustomField.clear();
        this.cacheByFieldConfigId.clear();
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cacheById.clear();
        this.cacheByCustomField.clear();
        this.cacheByFieldConfigId.clear();
    }

    @Override
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId != null) {
            CacheObject cacheObject = (CacheObject)this.cacheById.get(configSchemeId);
            if (cacheObject != null) {
                return (FieldConfigScheme)cacheObject.getValue();
            }
            FieldConfigScheme scheme = super.getFieldConfigScheme(configSchemeId);
            this.cacheById.putIfAbsent(configSchemeId, new CacheObject<FieldConfigScheme>(scheme));
            return scheme;
        }
        return null;
    }

    @Override
    public List<FieldConfigScheme> getConfigSchemesForCustomField(ConfigurableField field) {
        if (field == null) {
            return null;
        }
        String customFieldId = field.getId();
        CacheObject cacheObject = (CacheObject)this.cacheByCustomField.get(customFieldId);
        if (cacheObject != null) {
            return (List)cacheObject.getValue();
        }
        List schemes = CollectionUtil.copyAsImmutableList(super.getConfigSchemesForCustomField(field));
        this.cacheByCustomField.putIfAbsent(customFieldId, new CacheObject<List>(schemes));
        if (schemes != null) {
            for (FieldConfigScheme scheme : schemes) {
                Long schemeId = scheme.getId();
                if (this.cacheById.containsKey(schemeId)) continue;
                this.cacheById.putIfAbsent(schemeId, new CacheObject<FieldConfigScheme>(scheme));
            }
        }
        return schemes;
    }

    @Override
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        Long fieldConfigId = fieldConfig.getId();
        FieldConfigScheme scheme = (FieldConfigScheme)this.cacheByFieldConfigId.get(fieldConfigId);
        if (scheme == null) {
            scheme = super.getConfigSchemeForFieldConfig(fieldConfig);
            FieldConfigScheme result = this.cacheByFieldConfigId.putIfAbsent(fieldConfigId, scheme);
            return result == null ? scheme : result;
        }
        return scheme;
    }

    @Override
    public long getCacheSize() {
        return this.cacheByCustomField.size() + this.cacheById.size() + this.cacheByFieldConfigId.size();
    }

    @Override
    public void remove(Long fieldConfigSchemeId) {
        CacheObject cacheObject = (CacheObject)this.cacheById.get(fieldConfigSchemeId);
        if (cacheObject != null) {
            FieldConfig config;
            FieldConfigScheme configScheme = (FieldConfigScheme)cacheObject.getValue();
            this.cacheById.remove(fieldConfigSchemeId);
            ConfigurableField field = configScheme.getField();
            if (field != null) {
                this.cacheByCustomField.remove(field.getId());
            }
            if ((config = configScheme.getOneAndOnlyConfig()) != null) {
                this.cacheByFieldConfigId.remove(config.getId());
            }
        }
        super.remove(fieldConfigSchemeId);
    }

    @Override
    public void refreshCache() {
        this.init();
    }
}

