/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.ColumnViewDateTimeHelper;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.UpdatedDateSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.velocity.VelocityManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class UpdatedSystemField
extends NavigableFieldImpl
implements SearchableField,
DateField,
RestAwareField {
    private final ColumnViewDateTimeHelper columnViewDateTimeHelper;
    private final SearchHandlerFactory searchHandlerFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public UpdatedSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UpdatedDateSearchHandlerFactory searchHandlerFactory, ColumnViewDateTimeHelper columnViewDateTimeHelper, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super("updated", "issue.field.updated", "issue.column.heading.updated", "DESC", velocityManager, applicationProperties, authenticationContext);
        this.columnViewDateTimeHelper = columnViewDateTimeHelper;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.searchHandlerFactory = (SearchHandlerFactory)Assertions.notNull((String)"searchHandlerFactory", (Object)searchHandlerFactory);
    }

    public LuceneFieldSorter getSorter() {
        return DateFieldSorter.ISSUE_UPDATED_STATSMAPPER;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        return this.columnViewDateTimeHelper.render(this, fieldLayoutItem, displayParams, issue, issue.getUpdated());
    }

    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"datetime", (String)"updated");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Timestamp updated = issue.getUpdated();
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)Dates.asTimeString((Timestamp)updated)));
        if (renderedVersionRequired && updated != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)this.dateTimeFormatterFactory.formatter().forLoggedInUser().format((Date)updated)));
        }
        return fieldJsonRepresentation;
    }
}

