/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.option.FieldConfigSchemeOption;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.IssueTypeSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.IssueTypeStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.velocity.VelocityManager;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class IssueTypeSystemField
extends AbstractOrderableNavigableFieldImpl
implements IssueTypeField,
RestAwareField {
    private static final Logger log = Logger.getLogger(IssueTypeSystemField.class);
    private static final String ISSUE_TYPE_NAME_KEY = "issue.field.issuetype";
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;
    private final IssueTypeStatisticsMapper issueTypeStatisticsMapper;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final OptionSetManager optionSetManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final JiraBaseUrls jiraBaseUrls;

    public IssueTypeSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, WorkflowManager workflowManager, PermissionManager permissionManager, IssueTypeStatisticsMapper issueTypeStatisticsMapper, FieldConfigSchemeManager fieldConfigSchemeManager, OptionSetManager optionSetManager, IssueTypeSchemeManager issueTypeSchemeManager, IssueTypeSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls) {
        super("issuetype", ISSUE_TYPE_NAME_KEY, velocityManager, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.issueTypeStatisticsMapper = issueTypeStatisticsMapper;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.optionSetManager = optionSetManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map velocityParams = this.prepareVelocityParams(fieldLayoutItem, action, issue, displayParameters, operationContext);
        this.populateOptionsForProjects(velocityParams, issue, displayParameters, issue.isSubTask());
        velocityParams.put("createOperation", Boolean.TRUE);
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    private List populateOptionsForProjects(Map velocityParams, Issue issue, Map displayParameters, boolean isSubTask) {
        ProjectSystemField projectField = (ProjectSystemField)this.getParentField();
        Collection allowedProjects = isSubTask && issue != null ? EasyList.build((Object)issue.getProject()) : projectField.getAllowedProjects();
        ListOrderedMap projectToConfig = new ListOrderedMap();
        HashSet<FieldConfigScheme> releventConfigs = new HashSet<FieldConfigScheme>();
        for (GenericValue project : allowedProjects) {
            FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
            releventConfigs.add(configScheme);
            projectToConfig.put(project.getLong("id"), relevantConfig.getId());
        }
        velocityParams.put("projectToConfig", projectToConfig);
        ArrayList<FieldConfigSchemeOption> configOptions = new ArrayList<FieldConfigSchemeOption>();
        for (FieldConfigScheme configScheme : releventConfigs) {
            FieldConfig config = configScheme.getOneAndOnlyConfig();
            ArrayList<TextOption> options = new ArrayList<TextOption>(this.getOptionsForConfig(config, (IssueContext)issue, displayParameters, isSubTask));
            if (options.isEmpty()) continue;
            if (!isSubTask && this.issueTypeSchemeManager.getDefaultValue(config) == null) {
                TextOption pleaseSelect = new TextOption("", this.authenticationContext.getI18nHelper().getText("common.words.pleaseselect"));
                options.add(0, pleaseSelect);
            }
            configOptions.add(new FieldConfigSchemeOption(configScheme, options));
        }
        velocityParams.put("configOptions", configOptions);
        if (!isSubTask) {
            ListOrderedMap configToDefaultOption = new ListOrderedMap();
            for (FieldConfigScheme configScheme : releventConfigs) {
                FieldConfig config = configScheme.getOneAndOnlyConfig();
                IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(config);
                configToDefaultOption.put(config.getId(), defaultValue != null ? defaultValue.getId() : "");
            }
            if (configToDefaultOption.size() > 1) {
                velocityParams.put("configToDefaultOption", configToDefaultOption);
            } else if (velocityParams.get(this.getId()) == null) {
                velocityParams.put(this.getId(), configToDefaultOption.values().iterator().next());
            }
        }
        return configOptions;
    }

    private boolean isMoveIssue(Map displayParameters, IssueContext issue) {
        return displayParameters.containsKey("moveissue") && Boolean.TRUE.equals(displayParameters.get("moveissue")) && issue != null;
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map velocityParams = this.prepareVelocityParams(fieldLayoutItem, action, issue, displayParameters, operationContext);
        ArrayList<FieldConfigSchemeOption> configOptions = new ArrayList<FieldConfigSchemeOption>();
        FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(issue.getProject());
        FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
        Collection options = this.getOptionsForConfig(relevantConfig, issue, displayParameters);
        if ((options = CollectionUtils.select((Collection)options, (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters))).size() > 1) {
            configOptions.add(new FieldConfigSchemeOption(configScheme, options));
            velocityParams.put("configOptions", configOptions);
            return this.renderTemplate("issuetype-edit.vm", velocityParams);
        }
        velocityParams.put("noAllowedIssueTypes", Boolean.TRUE);
        velocityParams.put("hasMovePermission", this.getPermissionManager().hasPermission(25, issue.getProjectObject(), this.getAuthenticationContext().getLoggedInUser()));
        velocityParams.put("issue", issue);
        return this.renderTemplate("issuetype-edit-not-allowed.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map velocityParams = this.prepareVelocityParams(null, action, null, displayParameters, operationContext);
        if ("BulkMove".equals(bulkEditBean.getOperationName()) || "BulkMigrate".equals(bulkEditBean.getOperationName())) {
            this.populateOptionsForProjects(velocityParams, null, displayParameters, bulkEditBean.isSubTaskCollection());
        } else {
            Collection options = this.getAllowedIssueTypeOptionsForEdit(bulkEditBean.getSelectedIssues(), displayParameters);
            velocityParams.put("configOptions", EasyList.build((Object)((Object)new FieldConfigSchemeOption(null, options))));
        }
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    public String getEditHtml(OperationContext operationContext, Action action, List options) {
        Map velocityParams = this.prepareVelocityParams(null, action, null, EasyMap.build(), operationContext);
        velocityParams.put("configOptions", EasyList.build((Object)((Object)new FieldConfigSchemeOption(null, options))));
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        IssueType issueType = issue.getIssueTypeObject();
        velocityParams.put("issueTypeObject", issueType);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        GenericValue issueTypeGV = (GenericValue)value;
        IssueType issueType = this.constantsManager.getIssueTypeObject(issueTypeGV.getString("id"));
        velocityParams.put("issueTypeObject", issueType);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("issuetype-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        IssueType issueType = (IssueType)this.getDefaultValue(issue);
        if (issueType != null) {
            fieldValuesHolder.put(this.getId(), issueType.getId());
        }
    }

    public Object getDefaultValue(Issue issue) {
        return this.issueTypeSchemeManager.getDefaultValue(issue);
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        issue.setIssueType((GenericValue)this.getValueFromParams(fieldValueHolder));
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(true);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return issue.getIssueTypeObject() != null;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String issueTypeId = (String)fieldValuesHolder.get(this.getId());
        if (issueTypeId == null) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.noissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (this.getValueFromParams(fieldValuesHolder) == null) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            IssueType issueTypeObject = this.constantsManager.getIssueTypeObject(issueTypeId);
            if (issueTypeObject.isSubTask() && !issue.isSubTask()) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createsubtask.error.noparentissuekey"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!issueTypeObject.isSubTask() && issue.isSubTask()) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createsubtask.error.issuetypenotsubtask", issueTypeId), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                Collection allowedIssueTypeOptions = this.getOptionsForIssue(issue);
                if (!allowedIssueTypeOptions.contains((Object)new IssueConstantOption((IssueConstant)issueTypeObject))) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
        }
    }

    public Object getValueFromParams(Map params) {
        String issueTypeId = (String)params.get(this.getId());
        if (TextUtils.stringSet((String)issueTypeId)) {
            return this.constantsManager.getIssueType(issueTypeId);
        }
        return null;
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        Long issuetypeId = null;
        try {
            issuetypeId = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            issuetypeId = this.getIssueTypeIdByName(stringValue);
        }
        fieldValuesHolder.put(this.getId(), issuetypeId.toString());
    }

    private Long getIssueTypeIdByName(String stringValue) throws FieldValidationException {
        for (GenericValue issueTypeGV : this.constantsManager.getAllIssueTypes()) {
            if (!stringValue.equalsIgnoreCase(issueTypeGV.getString("name"))) continue;
            return Long.valueOf(issueTypeGV.getString("id"));
        }
        throw new FieldValidationException("Invalid issue type name '" + stringValue + "'.");
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                GenericValue issueType = (GenericValue)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, issueType.getString("id"), issueType.getString("name"));
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            GenericValue currentIssueType = (GenericValue)currentValue;
            if (value != null) {
                GenericValue issueType = (GenericValue)value;
                cib = new ChangeItemBean("jira", this.getId(), currentIssueType.getString("id"), currentIssueType.getString("name"), issueType.getString("id"), issueType.getString("name"));
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentIssueType.getString("id"), currentIssueType.getString("name"), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (Issue issue : selectedIssues) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        if (this.isHasCommonIssueTypes(selectedIssues)) {
            return "bulk.edit.issuetype.noissuetypes";
        }
        return null;
    }

    public boolean isHasCommonIssueTypes(Collection selectedIssues) {
        return this.getAllowedIssueTypeOptionsForEdit(selectedIssues, new HashMap()).isEmpty();
    }

    private Collection getAllowedIssueTypeOptionsForEdit(Collection issues, Map displayParameters) {
        Iterator iterator = issues.iterator();
        Issue issue = (Issue)iterator.next();
        Collection availableIssueTypes = CollectionUtils.select(new ArrayList(this.getOptionsForIssue(issue)), (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters));
        while (!availableIssueTypes.isEmpty() && iterator.hasNext()) {
            issue = (Issue)iterator.next();
            Collection newOptions = this.getOptionsForIssue(issue);
            newOptions = CollectionUtils.select((Collection)newOptions, (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters));
            availableIssueTypes.retainAll(newOptions);
        }
        return availableIssueTypes;
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), issue.getIssueTypeObject().getId());
    }

    private FieldLayoutManager getFieldLayoutManager() {
        return ManagerFactory.getFieldManager().getFieldLayoutManager();
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.issuetype";
    }

    public String getDefaultSortOrder() {
        return "DESC";
    }

    public LuceneFieldSorter getSorter() {
        return this.issueTypeStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("issue", issue);
        IssueType issueType = issue.getIssueTypeObject();
        velocityParams.put(this.getId(), issueType);
        return this.renderTemplate("issuetype-columnview.vm", velocityParams);
    }

    public Collection<Option> getOptionsForIssue(Issue issue, boolean isSubTask) {
        FieldConfig relevantConfig = this.getRelevantConfig((IssueContext)issue);
        return this.getOptionsForConfig(relevantConfig, (IssueContext)issue, EasyMap.build(), isSubTask);
    }

    public List getConfigurationItemTypes() {
        return Collections.EMPTY_LIST;
    }

    public List getAssociatedProjects() {
        return this.fieldConfigSchemeManager.getAssociatedProjects((ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return this.fieldConfigSchemeManager.getRelevantConfig(issueContext, (ConfigurableField)this);
    }

    public Field getParentField() {
        return ManagerFactory.getFieldManager().getField("project");
    }

    private Collection getOptionsForIssue(Issue issue) {
        FieldConfig relevantConfig = this.getRelevantConfig((IssueContext)issue);
        return this.getOptionsForConfig(relevantConfig, issue, EasyMap.build());
    }

    private Collection getOptionsForConfig(FieldConfig fieldConfig, Issue issue, Map displayParameters) {
        return this.getOptionsForConfig(fieldConfig, (IssueContext)issue, displayParameters, issue.isSubTask());
    }

    private Collection getOptionsForConfig(FieldConfig fieldConfig, IssueContext issue, Map displayParameters, boolean isSubTask) {
        Collection options = this.optionSetManager.getOptionsForConfig(fieldConfig).getOptions();
        options = CollectionUtils.select((Collection)options, (Predicate)new ValidIssueTypePredicate(issue, displayParameters, isSubTask));
        return options;
    }

    private Map prepareVelocityParams(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters, OperationContext operationContext) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        String issueTypeId = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), issueTypeId);
        if (issueTypeId != null && this.constantsManager.getIssueType(issueTypeId) != null) {
            velocityParams.put("issueTypeObject", this.constantsManager.getIssueTypeObject(issueTypeId));
        }
        return velocityParams;
    }

    public Collection getIssueConstants() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        IssueType issueType;
        Long issueTypeId;
        if (TextUtils.stringSet((String)changeHistory) && (issueTypeId = this.getIssueTypeIdByName(changeHistory)) != null && (issueType = this.constantsManager.getIssueTypeObject(issueTypeId.toString())) != null) {
            return issueType.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(fieldTypeInfoContext.getIssueContext().getProject());
        FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
        Collection<Object> allowedTypes = new ArrayList<IssueType>();
        if (fieldTypeInfoContext.getOperationContext().getIssueOperation().equals(IssueOperations.CREATE_ISSUE_OPERATION)) {
            allowedTypes.add(fieldTypeInfoContext.getIssueContext().getIssueTypeObject());
        } else {
            Collection options = this.getOptionsForConfig(relevantConfig, fieldTypeInfoContext.getIssueContext(), new HashMap(), false);
            options = CollectionUtils.select((Collection)options, (Predicate)new ValidForEditIssueTypes(fieldTypeInfoContext.getIssueContext(), new HashMap()));
            allowedTypes = Collections2.transform((Collection)options, (Function)new Function<Object, IssueType>(){

                public IssueType apply(@Nullable Object from) {
                    return IssueTypeSystemField.this.constantsManager.getIssueTypeObject(((Option)from).getId());
                }
            });
        }
        return new FieldTypeInfo(allowedTypes, null);
    }

    public JsonType getJsonSchema() {
        return IssueTypeSystemField.getIssueTypeJsonSchema();
    }

    public static JsonType getIssueTypeJsonSchema() {
        return JsonTypeBuilder.system((String)"issuetype", (String)"issuetype");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)IssueTypeJsonBean.shortBean((IssueType)issue.getIssueTypeObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    private class ValidForEditIssueTypes
    implements Predicate {
        FieldLayout currentFieldLayout;
        JiraWorkflow currentWorkflow;
        private final IssueContext issue;
        private final Map displayParameters;

        public ValidForEditIssueTypes(IssueContext issue, Map displayParameters) {
            this.issue = issue;
            this.displayParameters = displayParameters;
        }

        public boolean evaluate(Object object) {
            Option option = (Option)object;
            try {
                JiraWorkflow workflow;
                FieldLayout fieldLayoutScheme;
                if (this.currentFieldLayout == null || this.currentWorkflow == null) {
                    this.currentFieldLayout = IssueTypeSystemField.this.getFieldLayoutManager().getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeObject() != null ? this.issue.getIssueTypeObject().getId() : null);
                    this.currentWorkflow = IssueTypeSystemField.this.workflowManager.getWorkflow(this.issue.getProjectObject().getId(), this.issue.getIssueTypeObject() != null ? this.issue.getIssueTypeObject().getId() : null);
                }
                if (!this.currentFieldLayout.equals(fieldLayoutScheme = IssueTypeSystemField.this.getFieldLayoutManager().getFieldLayout(this.issue.getProjectObject(), option.getId()))) {
                    this.displayParameters.put("restrictedSelection", Boolean.TRUE);
                    return false;
                }
                if (!this.issue.getIssueTypeObject().getId().equals(option.getId()) && !this.currentWorkflow.equals(workflow = IssueTypeSystemField.this.workflowManager.getWorkflow(this.issue.getProjectObject().getId(), option.getId()))) {
                    this.displayParameters.put("restrictedSelection", Boolean.TRUE);
                    return false;
                }
                return true;
            }
            catch (WorkflowException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    private class ValidIssueTypePredicate
    implements Predicate {
        private final IssueConstantOption currentIssuesOption;
        private final IssueContext issue;
        private final Map displayParameters;
        private final Collection subTaskIds;
        private boolean subTaskOnly;

        public ValidIssueTypePredicate(IssueContext issue, Map displayParameters) {
            this.subTaskIds = GenericValueUtils.transformToStringIdsList((Collection)IssueTypeSystemField.this.constantsManager.getSubTaskIssueTypes());
            this.subTaskOnly = false;
            this.issue = issue;
            this.displayParameters = displayParameters;
            this.currentIssuesOption = issue != null ? new IssueConstantOption((IssueConstant)issue.getIssueTypeObject()) : null;
        }

        public ValidIssueTypePredicate(IssueContext issue, Map displayParameters, boolean isSubTask) {
            this(issue, displayParameters);
            this.subTaskOnly = isSubTask;
        }

        public boolean evaluate(Object object) {
            Option option = (Option)object;
            if (!this.isCorrectType(option)) {
                return false;
            }
            return !IssueTypeSystemField.this.isMoveIssue(this.displayParameters, this.issue) || !this.currentIssuesOption.equals(option);
        }

        private boolean isCorrectType(Option option) {
            if (this.subTaskOnly) {
                return this.subTaskIds.contains(option.getId());
            }
            return !this.subTaskIds.contains(option.getId());
        }
    }
}

