/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields;

import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCustomFieldValueProvider
implements CustomFieldValueProvider {
    private static final Logger log = Logger.getLogger(ProjectCustomFieldValueProvider.class);
    private final ProjectConverter projectConverter;

    public ProjectCustomFieldValueProvider(ProjectConverter projectConverter) {
        this.projectConverter = projectConverter;
    }

    public Object getStringValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
        GenericValue project = (GenericValue)this.getValue(customField, fieldValuesHolder);
        if (project != null) {
            return project.getLong("id").toString();
        }
        return null;
    }

    public Object getValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
        CustomFieldParams customFieldParams = customField.getCustomFieldValues((Map)fieldValuesHolder);
        Object obj = customField.getCustomFieldType().getStringValueFromCustomFieldParams(customFieldParams);
        Object id = null;
        if (obj instanceof List) {
            if (!((List)obj).isEmpty()) {
                id = ((List)obj).get(0);
            }
        } else {
            id = obj;
        }
        if (id instanceof String) {
            return this.getProjectGeneric((String)id);
        }
        return null;
    }

    private GenericValue getProjectGeneric(String projectId) {
        try {
            GenericValue project = this.projectConverter.getProject(projectId);
            if (project != null) {
                return project;
            }
        }
        catch (FieldValidationException e) {
            log.warn((Object)(projectId + " not a valid project id"));
        }
        return null;
    }
}

