/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.index.WriterWrapper;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

@ThreadSafe
class DefaultIndexEngine
implements DefaultIndex.Engine {
    private static final Logger log = Logger.getLogger(DefaultIndexEngine.class);
    private final WriterReference writerReference;
    private final SearcherReference searcherReference;
    private final FlushPolicy writePolicy;
    private final Configuration configuration;

    DefaultIndexEngine(final @NotNull Configuration configuration, @NotNull FlushPolicy writePolicy) {
        this(new SearcherFactory(configuration), new Function<Index.UpdateMode, Writer>(){

            public Writer get(Index.UpdateMode mode) {
                return new WriterWrapper(configuration, mode);
            }
        }, configuration, writePolicy);
    }

    DefaultIndexEngine(@NotNull Supplier<IndexSearcher> searcherFactory, Function<Index.UpdateMode, Writer> writerFactory, @NotNull Configuration configuration, @NotNull FlushPolicy writePolicy) {
        this.writePolicy = (FlushPolicy)((Object)Assertions.notNull((String)"writePolicy", (Object)((Object)writePolicy)));
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.searcherReference = new SearcherReference(searcherFactory);
        this.writerReference = new WriterReference(writerFactory);
    }

    @Override
    @NotNull
    public IndexSearcher getSearcher() {
        return (IndexSearcher)this.searcherReference.get(Index.UpdateMode.INTERACTIVE);
    }

    @Override
    public void clean() {
        this.searcherReference.close();
        this.writerReference.close();
        try {
            IndexWriterConfig luceneConfig = new IndexWriterConfig(DefaultIndexManager.LUCENE_VERSION, this.configuration.getAnalyzer());
            luceneConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            new IndexWriter(this.configuration.getDirectory(), luceneConfig).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Index.Operation operation) throws IOException {
        try {
            this.writePolicy.perform(operation, this.writerReference);
        }
        finally {
            this.searcherReference.close();
        }
    }

    @Override
    public void close() {
        this.writerReference.close();
        this.searcherReference.close();
    }

    private static class SearcherFactory
    implements Supplier<IndexSearcher> {
        private final Configuration configuration;
        private IndexReader oldReader = null;

        SearcherFactory(Configuration configuration) {
            this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        }

        public IndexSearcher get() {
            try {
                IndexReader reader;
                if (this.oldReader != null) {
                    try {
                        reader = this.oldReader.reopen(true);
                        if (reader != this.oldReader) {
                            this.oldReader.close();
                        }
                    }
                    catch (DelayCloseable.AlreadyClosedException ignore) {
                        log.warn((Object)"Tried to reopen the IndexReader, but it threw AlreadyClosedException. Opening a fresh IndexReader.");
                        reader = IndexReader.open((Directory)this.configuration.getDirectory(), (boolean)true);
                    }
                } else {
                    reader = IndexReader.open((Directory)this.configuration.getDirectory(), (boolean)true);
                }
                this.oldReader = reader;
                reader.incRef();
                return new IndexSearcher(reader);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    static abstract class ReferenceHolder<T>
    implements Function<Index.UpdateMode, T>,
    Closeable {
        private final AtomicReference<LazyReference<T>> reference = new AtomicReference();

        ReferenceHolder() {
        }

        @Override
        public final void close() {
            Reference supplier = this.reference.getAndSet(null);
            if (supplier != null) {
                try {
                    this.doClose(supplier.get());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }

        abstract void doClose(T var1);

        public final T get(final Index.UpdateMode mode) {
            while (true) {
                Reference ref = (Reference)this.reference.get();
                while (ref == null) {
                    this.reference.compareAndSet(null, new LazyReference<T>(){

                        protected T create() {
                            return ReferenceHolder.this.doCreate(mode);
                        }
                    });
                    ref = (Reference)this.reference.get();
                }
                try {
                    return this.open(ref.get());
                }
                catch (DelayCloseable.AlreadyClosedException alreadyClosedException) {
                    continue;
                }
                break;
            }
        }

        abstract T doCreate(Index.UpdateMode var1);

        abstract T open(T var1);

        final boolean isNull() {
            return this.reference.get() == null;
        }

        final T get() {
            LazyReference<T> lazyReference = this.reference.get();
            return (T)(lazyReference == null ? null : lazyReference.get());
        }

        final void setNull() {
            this.reference.set(null);
        }
    }

    @ThreadSafe
    private class WriterReference
    extends ReferenceHolder<Writer> {
        private final Function<Index.UpdateMode, Writer> writerFactory;
        private Index.UpdateMode mode;

        WriterReference(Function<Index.UpdateMode, Writer> writerFactory) {
            this.writerFactory = (Function)Assertions.notNull((String)"writerFactory", writerFactory);
        }

        public void commit() {
            if (!this.isNull()) {
                ((Writer)this.get()).commit();
            }
        }

        @Override
        Writer doCreate(Index.UpdateMode mode) {
            this.mode = mode;
            return (Writer)this.writerFactory.get((Object)mode);
        }

        @Override
        void doClose(Writer writer) {
            writer.close();
        }

        @Override
        Writer open(Writer writer) {
            return writer;
        }
    }

    @ThreadSafe
    private class SearcherReference
    extends ReferenceHolder<DelayCloseSearcher> {
        private final Supplier<IndexSearcher> searcherSupplier;

        SearcherReference(Supplier<IndexSearcher> searcherSupplier) {
            this.searcherSupplier = (Supplier)Assertions.notNull((String)"searcherSupplier", searcherSupplier);
        }

        @Override
        DelayCloseSearcher doCreate(Index.UpdateMode mode) {
            DefaultIndexEngine.this.writePolicy.commit(DefaultIndexEngine.this.writerReference);
            return new DelayCloseSearcher((IndexSearcher)this.searcherSupplier.get());
        }

        @Override
        DelayCloseSearcher open(DelayCloseSearcher searcher) {
            searcher.open();
            return searcher;
        }

        @Override
        void doClose(DelayCloseSearcher searcher) {
            searcher.closeWhenDone();
        }
    }

    static enum FlushPolicy {
        NONE{

            @Override
            void commit(WriterReference writer) {
            }
        }
        ,
        FLUSH{

            @Override
            void commit(WriterReference writer) {
                writer.commit();
            }
        }
        ,
        CLOSE{

            @Override
            synchronized void commit(WriterReference writer) {
                writer.close();
            }
        };


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void perform(Index.Operation operation, WriterReference writer) throws IOException {
            try {
                operation.perform((Writer)writer.get(operation.mode()));
            }
            finally {
                this.commit(writer);
            }
        }

        abstract void commit(WriterReference var1);
    }
}

