/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CachingFavouritesStore
implements FavouritesStore,
Startable {
    private final Map<Key, Collection<Long>> cache = LRUMap.synchronizedLRUMap((int)1000);
    private final FavouritesStore delegateStore;
    private final EventPublisher eventPublisher;

    public CachingFavouritesStore(FavouritesStore delegateStore, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.delegateStore = (FavouritesStore)Assertions.notNull((String)"delegateStore", (Object)delegateStore);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFavourite(User user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.addFavourite((User)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFavourite(String username, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.addFavourite((String)Assertions.notNull((String)"username", (Object)username), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(username, entity.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFavourite(User user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.removeFavourite((User)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    @Override
    public boolean isFavourite(User user, SharedEntity entity) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entity", (Object)entity);
        Collection<Long> ids = this.getFavouriteIds(user, entity.getEntityType());
        return ids.contains(entity.getId());
    }

    @Override
    public Collection<Long> getFavouriteIds(User user, SharedEntity.TypeDescriptor<?> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entityType", entityType);
        Key key = new Key(user.getName(), entityType);
        Collection<Long> ids = this.cache.get(key);
        if (ids == null) {
            ids = this.delegateStore.getFavouriteIds(user, entityType);
            if (ids == null) {
                ids = Collections.emptyList();
            }
            this.cache.put(key, ids);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFavouritesForUser(User user, SharedEntity.TypeDescriptor<?> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entityType", entityType);
        try {
            this.delegateStore.removeFavouritesForUser(user, entityType);
        }
        finally {
            this.flushFavourites(user, entityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFavouritesForEntity(SharedEntity entity) {
        try {
            this.delegateStore.removeFavouritesForEntity(entity);
        }
        finally {
            Map<Key, Collection<Long>> map = this.cache;
            synchronized (map) {
                Iterator<Map.Entry<Key, Collection<Long>>> iterator = this.cache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Key, Collection<Long>> entry = iterator.next();
                    Key entryKey = entry.getKey();
                    if (!entryKey.getType().equals((Object)entity.getEntityType()) || !entry.getValue().contains(entity.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSequence(User user, List<? extends SharedEntity> favouriteEntities) {
        try {
            this.delegateStore.updateSequence(user, favouriteEntities);
        }
        finally {
            if (!favouriteEntities.isEmpty()) {
                SharedEntity entity = favouriteEntities.get(0);
                this.flushFavourites(user, entity.getEntityType());
            }
        }
    }

    private void flushFavourites(User user, SharedEntity.TypeDescriptor<?> typeDescriptor) {
        this.flushFavourites(user.getName(), typeDescriptor);
    }

    private void flushFavourites(String username, SharedEntity.TypeDescriptor<?> typeDescriptor) {
        this.cache.remove(new Key(username, typeDescriptor));
    }

    private static class Key {
        private final String username;
        private final SharedEntity.TypeDescriptor<?> type;

        public Key(String username, SharedEntity.TypeDescriptor<?> type) {
            Assertions.notBlank((String)"username", (String)username);
            Assertions.notNull((String)"type", type);
            this.username = username;
            this.type = type;
        }

        public String getUsername() {
            return this.username;
        }

        public SharedEntity.TypeDescriptor<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.username.equals(key.username);
        }

        public int hashCode() {
            int result = this.username.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

