/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.external;

import com.atlassian.core.action.ActionDispatcher;
import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.util.HTMLUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.external.ExternalException;
import com.atlassian.jira.external.ExternalRuntimeException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

public class ExternalUtils {
    public static final String GENERIC_CONTENT_TYPE = "application/octet-stream";
    private final ProjectManager projectManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final ProjectComponentManager componentManager;
    private final CustomFieldManager customFieldManager;
    private final OptionsManager optionsManager;
    private final GenericDelegator genericDelegator;
    private final ActionDispatcher actionDispatcher;
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final PermissionManager permissionManager;
    private final IssueFactory issueFactory;
    private final AttachmentManager attachmentManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final FieldManager fieldManager;
    private final ApplicationProperties applicationProperties;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final CommentManager commentManager;
    private final UserUtil userUtil;
    private static final Logger log = Logger.getLogger(ExternalUtils.class);
    public static final String TYPE_SEPERATOR = ":";
    public static final String CF_PREFIX = "customfield_";
    private static final String SEARCHER = "searcher";
    private static final String TEXT_FIELD_TYPE = "textfield";
    private static final String TEXT_FIELD_SEARCHER = "textsearcher";
    private static final String DATE_FIELD_TYPE = "datepicker";
    private static final String DATE_FIELD_SEARCHER = "daterange";

    public ExternalUtils(ProjectManager projectManager, PermissionSchemeManager permissionSchemeManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, VersionManager versionManager, ProjectComponentManager componentManager, CustomFieldManager customFieldManager, OptionsManager optionsManager, GenericDelegator genericDelegator, ActionDispatcher actionDispatcher, ConstantsManager constantsManager, WorkflowManager workflowManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager, PermissionManager permissionManager, IssueFactory issueFactory, AttachmentManager attachmentManager, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, FieldManager fieldManager, ApplicationProperties applicationProperties, IssueTypeSchemeManager issueTypeSchemeManager, CommentManager commentManager, UserUtil userUtil) {
        this.projectManager = projectManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.versionManager = versionManager;
        this.componentManager = componentManager;
        this.customFieldManager = customFieldManager;
        this.optionsManager = optionsManager;
        this.genericDelegator = genericDelegator;
        this.actionDispatcher = actionDispatcher;
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.permissionManager = permissionManager;
        this.issueFactory = issueFactory;
        this.attachmentManager = attachmentManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.fieldManager = fieldManager;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.commentManager = commentManager;
        this.userUtil = userUtil;
    }

    public GenericValue getProject(ExternalProject externalProject) {
        GenericValue projectGV = null;
        if (StringUtils.isNotEmpty((String)externalProject.getKey())) {
            projectGV = this.projectManager.getProjectByKey(externalProject.getKey());
        }
        if (projectGV == null && StringUtils.isNotEmpty((String)externalProject.getName())) {
            projectGV = this.projectManager.getProjectByName(externalProject.getName());
        }
        return projectGV;
    }

    public Project getProjectObject(ExternalProject externalProject) {
        Project project = null;
        if (StringUtils.isNotEmpty((String)externalProject.getKey())) {
            project = this.projectManager.getProjectObjByKey(externalProject.getKey());
        }
        if (project == null && StringUtils.isNotEmpty((String)externalProject.getName())) {
            project = this.projectManager.getProjectObjByName(externalProject.getName());
        }
        return project;
    }

    public GenericValue createProject(ExternalProject externalProject) throws ExternalException {
        return this.createProjectObject(externalProject).getGenericValue();
    }

    public Project createProjectObject(ExternalProject externalProject) throws ExternalException {
        try {
            if (externalProject.getLead() == null) {
                externalProject.setLead(this.authenticationContext.getLoggedInUser().getName());
            }
            if (externalProject.getAssigneeType() == null) {
                if (this.isUnassignedIssuesAllowed()) {
                    externalProject.setAssigneeType(String.valueOf(3L));
                } else {
                    externalProject.setAssigneeType(String.valueOf(2L));
                }
            }
            Project project = this.projectManager.createProject(externalProject.getName(), externalProject.getKey(), externalProject.getDescription(), externalProject.getLead(), externalProject.getUrl(), new Long(externalProject.getAssigneeType()));
            this.permissionSchemeManager.addDefaultSchemeToProject(project.getGenericValue());
            this.issueTypeScreenSchemeManager.associateWithDefaultScheme(project.getGenericValue());
            return project;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create project: " + externalProject, e);
        }
    }

    private boolean isUnassignedIssuesAllowed() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }

    public Version createVersion(ExternalProject externalProject, ExternalVersion externalVersion) {
        Version jiraVersion = null;
        try {
            String versionName = externalVersion.getName();
            jiraVersion = this.versionManager.createVersion(versionName, externalVersion.getReleaseDate(), externalVersion.getDescription(), externalProject.getProjectGV().getLong("id"), null);
            if (externalVersion.isArchived()) {
                this.versionManager.archiveVersion(jiraVersion, true);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while creating Version " + externalVersion), (Throwable)e);
        }
        return jiraVersion;
    }

    public Version getVersion(ExternalProject externalProject, ExternalVersion externalVersion) {
        Version jiraVersion = null;
        try {
            String versionName = externalVersion.getName();
            jiraVersion = this.versionManager.getVersion(externalProject.getProjectGV().getLong("id"), versionName);
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while retrieving Version " + externalVersion), (Throwable)e);
        }
        return jiraVersion;
    }

    public GenericValue createComponent(ExternalProject externalProject, ExternalComponent externalComponent) {
        GenericValue jiraComponent = null;
        try {
            String componentName = externalComponent.getName();
            ProjectComponent projectComponent = this.componentManager.create(componentName, null, null, 0L, externalProject.getProjectGV().getLong("id"));
            jiraComponent = this.componentManager.convertToGenericValue(projectComponent);
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while creating Component " + externalComponent), (Throwable)e);
        }
        return jiraComponent;
    }

    public GenericValue getComponent(ExternalProject externalProject, ExternalComponent externalComponent) {
        GenericValue jiraComponent = null;
        try {
            String componentName = externalComponent.getName();
            ProjectComponent projectComponent = this.componentManager.findByComponentName(externalProject.getProjectGV().getLong("id"), componentName);
            jiraComponent = this.componentManager.convertToGenericValue(projectComponent);
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while retrieving Component " + externalComponent), (Throwable)e);
        }
        return jiraComponent;
    }

    public User createUser(ExternalUser externalUser) {
        try {
            return this.userUtil.createUserNoNotification(externalUser.getName(), externalUser.getPassword(), externalUser.getEmail(), externalUser.getFullname());
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while creating User " + externalUser), (Throwable)e);
            return null;
        }
    }

    public boolean canActivateNumberOfUsers(int numberOfUsers) {
        return this.userUtil.canActivateNumberOfUsers(numberOfUsers);
    }

    public User getJiraUser(ExternalUser externalUser) {
        return this.userUtil.getUser(externalUser.getName());
    }

    public GenericValue createIssue(Issue issue, String status, String resolution) throws ExternalException {
        try {
            if (StringUtils.isNotBlank((String)status)) {
                this.checkStatus(issue, status);
            }
            GenericValue issueGV = this.issueManager.createIssue(this.authenticationContext.getLoggedInUser(), issue);
            if (StringUtils.isNotBlank((String)status)) {
                this.setCurrentWorkflowStep(issueGV, status, resolution);
            }
            return issueGV;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create issue: " + issue, e);
        }
    }

    protected void checkStatus(Issue issue, String status) throws WorkflowException, ExternalException {
        if (issue != null) {
            GenericValue statusGV = this.constantsManager.getStatus(status);
            if (statusGV != null) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
                StepDescriptor linkedStep = workflow.getLinkedStep(statusGV);
                if (linkedStep == null) {
                    throw new ExternalException("Status '" + statusGV.getString("name") + "' does not have a linked step in the '" + workflow.getName() + "' workflow. Please map to a different status.");
                }
            } else {
                throw new ExternalException("Cannot find status with id '" + status + "'.");
            }
        }
    }

    protected GenericValue createIssue(Map fields) throws CreateException {
        return this.issueManager.createIssue(this.authenticationContext.getLoggedInUser(), fields);
    }

    public void setCurrentWorkflowStep(GenericValue issue, String status, String resolution) throws GenericEntityException, WorkflowException {
        if (issue != null) {
            GenericValue statusGV = this.constantsManager.getStatus(status);
            if (statusGV != null) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
                StepDescriptor linkedStep = workflow.getLinkedStep(statusGV);
                List wfCurrentStepCollection = this.genericDelegator.findByAnd("OSCurrentStep", MapBuilder.build((Object)"entryId", (Object)issue.getLong("workflowId")));
                if (wfCurrentStepCollection != null && !wfCurrentStepCollection.isEmpty()) {
                    GenericValue wfCurrentStep = (GenericValue)wfCurrentStepCollection.iterator().next();
                    if (linkedStep != null) {
                        wfCurrentStep.set("stepId", (Object)linkedStep.getId());
                        wfCurrentStep.store();
                    } else {
                        log.error((Object)("Workflow '" + workflow.getName() + "' does not have a step for status '" + statusGV.getString("name") + "'."));
                    }
                } else {
                    log.warn((Object)"Workflow Id not found");
                }
                issue.set("status", (Object)status);
                issue.set("resolution", (Object)resolution);
                issue.store();
            } else {
                log.warn((Object)("Status' GV for '" + status + "' was null. Issue not updated. " + issue));
            }
        }
    }

    public CustomField getCustomField(ExternalCustomFieldValue customFieldValue) {
        String customfieldId = customFieldValue.getKey();
        return this.getCustomField(customfieldId);
    }

    public CustomField getCustomField(String customfieldId) {
        CustomField customFieldObject = null;
        try {
            try {
                customFieldObject = this.customFieldManager.getCustomFieldObject(customfieldId);
            }
            catch (NumberFormatException e) {
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (customFieldObject == null) {
                String fieldName = this.extractCustomFieldId(customfieldId);
                customFieldObject = this.customFieldManager.getCustomFieldObjectByName(fieldName);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return customFieldObject;
    }

    public void addOptions(CustomField customFieldObject, ExternalCustomFieldValue customFieldValue, GenericValue issueGV) {
        if (customFieldObject != null && customFieldObject.getCustomFieldType() instanceof MultipleSettableCustomFieldType) {
            String cfvalue = customFieldValue.getValue();
            List values = customFieldObject.getCustomFieldType() instanceof MultiSelectCFType ? MultiSelectCFType.extractTransferObjectFromString(cfvalue) : CollectionBuilder.newBuilder((Object[])new String[]{cfvalue}).asList();
            MutableIssue issue = this.issueFactory.getIssue(issueGV);
            FieldConfig config = customFieldObject.getRelevantConfig((Issue)issue);
            Options options = customFieldObject.getOptions(null, config, null);
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value) || options.getOptionForValue(value, null) != null) continue;
                int sequence = options.size();
                this.optionsManager.createOption(config, null, new Long(sequence), value);
            }
        }
    }

    public CustomField createCustomField(ExternalCustomFieldValue customFieldValue) {
        CustomField customFieldObject = null;
        String customfieldId = customFieldValue.getKey();
        String fieldName = this.extractCustomFieldId(customfieldId);
        String fieldType = this.extractCustomFieldType(customfieldId);
        try {
            customFieldObject = this.createCustomField(fieldName, fieldType);
        }
        catch (ExternalException e) {
            log.warn((Object)("Unable to create custom field " + customFieldValue), (Throwable)((Object)e));
        }
        return customFieldObject;
    }

    public String extractCustomFieldType(String customfieldId) {
        return StringUtils.substringAfter((String)customfieldId, (String)TYPE_SEPERATOR);
    }

    public String extractCustomFieldId(String customfieldId) {
        String fieldId = StringUtils.contains((String)customfieldId, (String)TYPE_SEPERATOR) ? StringUtils.substringBetween((String)customfieldId, (String)CF_PREFIX, (String)TYPE_SEPERATOR) : StringUtils.substringAfter((String)customfieldId, (String)CF_PREFIX);
        return fieldId;
    }

    private CustomField createCustomField(String customFieldName, String type) throws ExternalException {
        try {
            CustomFieldSearcher searcher;
            CustomFieldType cfType;
            if ("select".equals(type) || "userpicker".equals(type) || "multiselect".equals(type)) {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:" + type);
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:" + type + SEARCHER);
            } else if ("date".equals(type) || DATE_FIELD_TYPE.equals(type)) {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:datepicker");
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:daterange");
            } else {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:textfield");
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
            }
            CustomField customField = this.customFieldManager.createCustomField(customFieldName, customFieldName, cfType, searcher, EasyList.build((Object)GlobalIssueContext.getInstance()), EasyList.buildNull());
            this.associateCustomFieldWithScreen(customField, null);
            return customField;
        }
        catch (GenericEntityException e) {
            throw new ExternalException(e);
        }
    }

    public void associateCustomFieldWithScreen(CustomField customField, FieldScreen screen) {
        if (screen == null) {
            screen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        }
        if (screen != null && screen.getTabs() != null && !screen.getTabs().isEmpty()) {
            FieldScreenTab tab = screen.getTab(0);
            tab.addFieldScreenLayoutItem(customField.getId());
        }
    }

    public void addComments(GenericValue issue, ExternalComment externalComment, boolean dispatchEvent) throws ExternalException {
        this.addComments(issue, externalComment, dispatchEvent, true);
    }

    public void addComments(GenericValue issue, ExternalComment externalComment, boolean dispatchEvent, boolean tweakIssueUpdateDate) throws ExternalException {
        User commenter;
        String username = externalComment.getUsername();
        if (username != null) {
            commenter = this.userUtil.getUser(username);
            if (commenter == null) {
                log.warn((Object)("Commenter named " + username + " not found. Creating issue with currently logged in user instead"));
                commenter = this.authenticationContext.getLoggedInUser();
            }
        } else {
            commenter = this.authenticationContext.getLoggedInUser();
        }
        if (!this.permissionManager.hasPermission(15, issue, commenter)) {
            String s = "Comment not created. The user (" + commenter.getDisplayName() + ") do not have permission to comment on an issue in project: " + this.projectManager.getProject(issue.getLong("project")).getString("name");
            log.warn((Object)s);
            throw new ExternalException(s);
        }
        try {
            String author = commenter.getName();
            Date timePerformed = externalComment.getTimePerformed();
            this.commentManager.create((Issue)this.issueFactory.getIssue(issue), author, author, externalComment.getBody(), externalComment.getGroupLevel(), externalComment.getRoleLevelId(), timePerformed, timePerformed, dispatchEvent, tweakIssueUpdateDate);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create comment " + externalComment + ". Comment not created"), (Throwable)e);
            throw new ExternalException(e);
        }
    }

    public void attachFile(ExternalAttachment externalAttachment, GenericValue issueGv) throws ExternalException {
        User user;
        String username = externalAttachment.getAttacher();
        if (username != null) {
            user = this.userUtil.getUserObject(username);
            if (user == null) {
                log.warn((Object)("User named " + username + " not found. attaching to issue with currently logged in user instead"));
                user = this.authenticationContext.getLoggedInUser();
            }
        } else {
            user = this.authenticationContext.getLoggedInUser();
        }
        try {
            this.attachmentManager.createAttachment(externalAttachment.getAttachedFile(), externalAttachment.getFileName(), GENERIC_CONTENT_TYPE, user, issueGv, Collections.EMPTY_MAP, externalAttachment.getAttachedDate());
        }
        catch (AttachmentException e) {
            throw new ExternalException(e);
        }
    }

    private IssueLinkType createOrFindLinkType(String name) throws ExternalException {
        Collection dependency = this.issueLinkTypeManager.getIssueLinkTypesByName(name);
        if (dependency.isEmpty()) {
            try {
                this.issueLinkTypeManager.createIssueLinkType(name, name, name, null);
            }
            catch (IllegalArgumentException e) {
                throw new ExternalException(e);
            }
            dependency = this.issueLinkTypeManager.getIssueLinkTypesByName(name);
        }
        return (IssueLinkType)dependency.iterator().next();
    }

    public GenericValue getConstant(String constantName, String constantType) {
        IssueConstant constantById = this.constantsManager.getConstantObject(constantType, constantName);
        if (constantById == null) {
            IssueConstant constantByName = this.constantsManager.getIssueConstantByName(constantType, constantName);
            return constantName != null ? constantByName.getGenericValue() : null;
        }
        return constantById.getGenericValue();
    }

    public String addConstant(String constantName, String constantType) throws ExternalException {
        if ("IssueType".equals(constantType)) {
            Map parameters = MapBuilder.newBuilder().add((Object)"iconurl", (Object)"/images/icons/genericissue.gif").toMap();
            return this.addConstant(constantName, "IssueType", parameters);
        }
        if ("Priority".equals(constantType)) {
            Map parameters = MapBuilder.newBuilder().add((Object)"iconurl", (Object)"/images/icons/priority_major.gif").add((Object)"statusColor", (Object)"#009900").toMap();
            return this.addConstant(constantName, "Priority", parameters);
        }
        if ("Resolution".equals(constantType)) {
            return this.addConstant(constantName, "Resolution", null);
        }
        throw new ExternalException("Unknown contantType:" + constantType);
    }

    protected String addConstant(String constantName, String constantType, Map<String, String> extraParams) throws ExternalException {
        try {
            Map parameters = MapBuilder.newBuilder(extraParams).add((Object)"name", (Object)constantName).add((Object)"description", (Object)constantName).toMap();
            ActionResult aResult = this.actionDispatcher.execute("Add" + constantType, parameters);
            ActionUtils.checkForErrors(aResult);
            IssueConstant constant = this.constantsManager.getIssueConstantByName(constantType, constantName);
            return constant.getId();
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create " + constantType + " " + constantName, e);
        }
    }

    public MutableIssue newIssueInstance() {
        return this.issueFactory.getIssue();
    }

    private String preFilterSummary(ExternalIssue externalIssue) {
        String summary = externalIssue.getSummary();
        if (StringUtils.isBlank((String)summary) && !StringUtils.isNotBlank((String)externalIssue.getDescription())) {
            return StringUtils.abbreviate((String)externalIssue.getDescription(), (int)250);
        }
        return summary;
    }

    private Timestamp toTimeStamp(Date date) {
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static String getTextDataFromMimeMessage(String s) {
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            MimeMessage message = new MimeMessage(session, (InputStream)is);
            return ExternalUtils.getTextDataFromMimeMessage(message);
        }
        catch (Exception e) {
            throw new ExternalRuntimeException(e);
        }
    }

    private static String getTextDataFromMimeMessage(MimeMessage message) throws IOException, MessagingException {
        Object content = message.getContent();
        if (content instanceof Multipart) {
            Multipart mm = (Multipart)content;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mm.getCount(); ++i) {
                BodyPart part = mm.getBodyPart(i);
                if (part.getContentType().startsWith("text") && i == 0) {
                    sb.append(ExternalUtils.getCleanedContent((Part)part));
                    continue;
                }
                if (part.getFileName() != null || !(part.getContent() instanceof MimeMessage)) continue;
                sb.append(ExternalUtils.getTextDataFromMimeMessage((MimeMessage)part.getContent()));
            }
            return sb.toString();
        }
        return ExternalUtils.getCleanedContent((Part)message);
    }

    private static String getCleanedContent(Part part) throws IOException, MessagingException {
        String content = part.getContent().toString();
        if (part.getContentType().startsWith("text/html")) {
            String noTags = HTMLUtils.stripTags((String)content);
            try {
                return StringEscapeUtils.unescapeHtml((String)noTags);
            }
            catch (NumberFormatException e) {
                return ImportUtils.stripHTMLStrings((String)noTags);
            }
        }
        return content;
    }

    public GenericValue getProjectCategory(String projectCategoryName) {
        return this.projectManager.getProjectCategoryByName(projectCategoryName);
    }

    public ProjectCategory getProjectCategoryObject(String projectCategoryName) {
        return this.projectManager.getProjectCategoryObjectByName(projectCategoryName);
    }

    public GenericValue createProjectCategory(String projectCategoryName) throws ExternalException {
        ProjectCategory projectCategory = this.projectManager.createProjectCategory(projectCategoryName, "");
        return this.projectManager.getProjectCategory(projectCategory.getId());
    }

    public ProjectCategory createProjectCategoryObject(String projectCategoryName) throws ExternalException {
        return this.projectManager.createProjectCategory(projectCategoryName, "");
    }

    public void associateProjectCategory(GenericValue project, GenericValue projectCategory) {
        this.projectManager.setProjectCategory(project, projectCategory);
    }

    public void associateProjectCategory(Project project, ProjectCategory category) {
        this.projectManager.setProjectCategory(project, category);
    }
}

