/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringEscapeUtils;

@Immutable
public class DateVelocityUtils {
    private final DateTimeFormatter dateTimeFormatter;

    public DateVelocityUtils(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withSystemZone() : null;
    }

    public String formatRelative(Date date) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormatter.withStyle(DateTimeStyle.RELATIVE_WITHOUT_TIME).format(date));
    }

    public String formatRSS(Date date) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormatter.withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME).format(date));
    }
}

