/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.db.DatabaseConfig;
import com.atlassian.jira.configurator.db.MySqlDatabaseConfig;
import com.atlassian.jira.configurator.db.OracleDatabaseConfig;
import com.atlassian.jira.configurator.db.PostgresDatabaseConfig;
import com.atlassian.jira.configurator.db.SqlServerDatabaseConfig;

public class DatabaseConfigFactory {
    public static DatabaseConfig getDatabaseConfigFor(DatabaseType databaseType) {
        switch (databaseType) {
            case MY_SQL: {
                return new MySqlDatabaseConfig();
            }
            case ORACLE: {
                return new OracleDatabaseConfig();
            }
            case POSTGRES: {
                return new PostgresDatabaseConfig();
            }
            case SQL_SERVER: {
                return new SqlServerDatabaseConfig();
            }
        }
        throw new IllegalArgumentException("Unknown DatabaseType " + (Object)((Object)databaseType));
    }
}

