/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.JiraHomeDatabaseConfigurationLoader;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.exception.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsLoader {
    private static final String DEV_MODE_SERVER_XML = "tomcatBase/tomcat6/conf/server.xml";
    private static final boolean devMode = new File("tomcatBase/tomcat6/conf/server.xml").exists();

    public static Settings loadCurrentSettings() throws ParserConfigurationException, IOException, SAXException, ParseException {
        Settings settings = new Settings();
        SettingsLoader.loadApplicationProperties(settings);
        SettingsLoader.loadDbConfig(settings);
        SettingsLoader.loadServerXmlSettings(settings);
        return settings;
    }

    public static void saveSettings(Settings newSettings) throws IOException {
        SettingsLoader.saveSettingsToApplicationProperties(newSettings);
        SettingsLoader.saveSettingsToServerXml(newSettings);
        SettingsLoader.saveDbConfig(newSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSettingsToApplicationProperties(Settings newSettings) throws IOException {
        if (newSettings.getJiraHome() == null || newSettings.getJiraHome().trim().length() == 0) {
            throw new IOException("Please set a value for jira-home.");
        }
        File jiraHomeDirectory = new File(newSettings.getJiraHome());
        if (jiraHomeDirectory.exists()) {
            if (!jiraHomeDirectory.isDirectory()) {
                throw new IOException("jira-home '" + newSettings.getJiraHome() + "' is not a directory.");
            }
        } else {
            boolean created = jiraHomeDirectory.mkdirs();
            if (!created) {
                throw new IOException("Unable to create jira-home '" + newSettings.getJiraHome() + "'");
            }
        }
        BufferedReader reader = new BufferedReader(new FileReader(SettingsLoader.getJiraApplicationProperties()));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean jiraHomeSet = false;
            while ((line = reader.readLine()) != null) {
                if (SettingsLoader.isJiraHomeProperty(line)) {
                    sb.append("jira.home = ").append(SettingsLoader.encodeForPropertiesFile(newSettings.getJiraHome())).append("\n");
                    jiraHomeSet = true;
                    continue;
                }
                sb.append(line).append("\n");
            }
            if (!jiraHomeSet) {
                throw new IOException("Unable to find the jira.home property to replace in the jira.application.properties file (" + SettingsLoader.getJiraApplicationProperties() + ").");
            }
        }
        finally {
            reader.close();
        }
        FileWriter writer = new FileWriter(SettingsLoader.getJiraApplicationProperties());
        try {
            writer.write(sb.toString());
        }
        finally {
            writer.close();
        }
    }

    private static String encodeForPropertiesFile(String value) {
        return value.replace("\\", "\\\\");
    }

    private static boolean isJiraHomeProperty(String line) {
        if (line.startsWith("jira.home")) {
            String value = line.substring("jira.home".length());
            if ((value = value.trim()).startsWith("=")) {
                return true;
            }
        }
        return false;
    }

    private static void saveSettingsToServerXml(Settings newSettings) throws IOException {
        Document doc;
        try {
            doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
            SettingsLoader.saveNetworkingSettingsToServerXml(newSettings, doc);
        }
        catch (Exception ex) {
            String message = "An error occured while trying to save settings. Your settings may be in an invalid state.";
            if (ex.getMessage() != null) {
                message = message + " " + ex.getMessage();
            }
            throw new IOException(message);
        }
        SettingsLoader.writeXmlFile(doc, SettingsLoader.getServerXmlFile());
    }

    private static void saveNetworkingSettingsToServerXml(Settings newSettings, Document doc) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        NamedNodeMap attributes = serverNode.getAttributes();
        Attr attr = doc.createAttribute("port");
        attr.setNodeValue(newSettings.getControlPort());
        attributes.setNamedItem(attr);
        Node childNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        childNode = SettingsLoader.getChildNodeWithAttribute(childNode, "Connector", "protocol", "HTTP/1.1");
        attributes = childNode.getAttributes();
        attr = doc.createAttribute("port");
        attr.setNodeValue(newSettings.getHttpPort());
        attributes.setNamedItem(attr);
    }

    private static void saveDbConfig(Settings newSettings) {
        JiraHomeDatabaseConfigurationLoader databaseConfigurationLoader = new JiraHomeDatabaseConfigurationLoader(newSettings.getJiraHome());
        int dbPoolSize = Integer.parseInt(newSettings.getDbPoolSize());
        String validationQuery = newSettings.getDatabaseType() == DatabaseType.MY_SQL ? "select 1" : null;
        Long minEvictableTimeMillis = null;
        Long timeBetweenEvictionRunsMillis = null;
        if (newSettings.getDatabaseType() == DatabaseType.HSQL) {
            minEvictableTimeMillis = 4000L;
            timeBetweenEvictionRunsMillis = 5000L;
        }
        JdbcDatasource.setRegisterDriverOnConstruct(false);
        JdbcDatasource datasource = new JdbcDatasource(newSettings.getJdbcUrl(), newSettings.getJdbcDriverClass(), newSettings.getDbUsername(), newSettings.getDbPassword(), dbPoolSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis);
        String databaseTypeName = SettingsLoader.getFieldTypeName(newSettings.getDatabaseType());
        DatabaseConfig databaseConfig = new DatabaseConfig(databaseTypeName, newSettings.getSchemaName(), datasource);
        databaseConfigurationLoader.saveDatabaseConfiguration(databaseConfig);
    }

    private static String getFieldTypeName(DatabaseType databaseType) {
        switch (databaseType) {
            case HSQL: {
                return "hsql";
            }
            case SQL_SERVER: {
                return "mssql";
            }
            case MY_SQL: {
                return "mysql";
            }
            case ORACLE: {
                return "oracle10g";
            }
            case POSTGRES: {
                return "postgres72";
            }
        }
        throw new IllegalArgumentException("Unknown DatabaseType " + (Object)((Object)databaseType));
    }

    private static void writeXmlFile(Document doc, String filename) throws IOException {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(filename);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception ex) {
            String errorMessage = "An error occurred while writing XML file '" + filename + "'.";
            System.err.println(errorMessage);
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            throw new IOException(errorMessage + "\n" + ex.getMessage());
        }
    }

    private static Document parseDocument(String filename) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(filename);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
    }

    private static void loadDbConfig(Settings settings) throws IOException {
        if (settings.getJiraHome() == null || settings.getJiraHome().length() == 0) {
            System.out.println("jira-home not configured - no database settings can be loaded.");
            return;
        }
        File dbConfigFile = new File(settings.getJiraHome(), "dbconfig.xml");
        if (!dbConfigFile.exists()) {
            System.out.println("DB config file '" + dbConfigFile.getAbsolutePath() + "' is not created yet - loading database settings as blank.");
            return;
        }
        Document doc = SettingsLoader.parseDocument(dbConfigFile.getAbsolutePath());
        try {
            SettingsLoader.loadDbConfig(doc, settings);
        }
        catch (ParseException ex) {
            throw new IOException("Unable to parse the config file '" + SettingsLoader.getServerXmlFile() + "'. " + ex.getMessage());
        }
    }

    private static void loadDbConfig(Document doc, Settings settings) throws ParseException {
        Node childNode = SettingsLoader.getOnlyChildNode(doc, "jira-database-config");
        childNode = SettingsLoader.getOnlyChildNode(childNode, "jdbc-datasource");
        settings.setJdbcDriverClass(SettingsLoader.getOnlyChildNode(childNode, "driver-class").getTextContent());
        settings.setJdbcUrl(SettingsLoader.getOnlyChildNode(childNode, "url").getTextContent());
        settings.setDbUsername(SettingsLoader.getOnlyChildNode(childNode, "username").getTextContent());
        settings.setDbPassword(SettingsLoader.getOnlyChildNode(childNode, "password").getTextContent());
        settings.setDbPoolSize(SettingsLoader.getOnlyChildNode(childNode, "pool-size").getTextContent());
        childNode = SettingsLoader.getOnlyChildNode(childNode, "schema-name");
        if (childNode != null) {
            settings.setSchemaName(childNode.getTextContent());
        }
    }

    private static void loadServerXmlSettings(Settings settings) throws IOException {
        Document doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
        try {
            SettingsLoader.loadWebServerSettings(doc, settings);
        }
        catch (ParseException ex) {
            throw new IOException("Unable to parse the config file '" + SettingsLoader.getServerXmlFile() + "'. " + ex.getMessage());
        }
    }

    private static void loadWebServerSettings(Document doc, Settings settings) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        settings.setControlPort(SettingsLoader.getAttributeValue(serverNode, "port"));
        Node childNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        childNode = SettingsLoader.getChildNodeWithAttribute(childNode, "Connector", "protocol", "HTTP/1.1");
        settings.setHttpPort(SettingsLoader.getAttributeValue(childNode, "port"));
    }

    private static void loadApplicationProperties(Settings settings) throws IOException {
        File jiraApplicationProperties = new File(SettingsLoader.getJiraApplicationProperties());
        SettingsLoader.logInfo("Loading application properties from " + jiraApplicationProperties.getCanonicalPath());
        FileInputStream propertiesInputStream = new FileInputStream(jiraApplicationProperties);
        try {
            String jiraHome = SettingsLoader.getJiraHomeValue(propertiesInputStream);
            if (File.separatorChar == '\\') {
                jiraHome = jiraHome.replace("/", "\\");
            }
            settings.setJiraHome(jiraHome);
        }
        catch (ParseException ex) {
            throw new IOException("Error parsing " + jiraApplicationProperties + ". " + ex.getMessage());
        }
        finally {
            ((InputStream)propertiesInputStream).close();
        }
    }

    private static void logInfo(String message) {
        System.out.println(message);
    }

    static String getJiraHomeValue(InputStream propertiesInputStream) throws ParseException, IOException {
        Properties applicationProperties = new Properties();
        applicationProperties.load(propertiesInputStream);
        String jiraHome = applicationProperties.getProperty("jira.home");
        if (jiraHome == null) {
            throw new ParseException("Unable to find the jira.home property.");
        }
        return jiraHome;
    }

    private static Node getChildNodeWithAttribute(Node parentNode, String tagName, String attributeName, String attributeValue) {
        List<Node> nodes = SettingsLoader.getChildNodes(parentNode, tagName);
        for (Node node : nodes) {
            String value = SettingsLoader.getAttributeValue(node, attributeName);
            if (!attributeValue.equals(value)) continue;
            return node;
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attrNode = attributes.getNamedItem(attributeName);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getNodeValue();
    }

    private static Node getOnlyChildNode(Node parentNode, String tagName) throws ParseException {
        List<Node> childNodes = SettingsLoader.getChildNodes(parentNode, tagName);
        if (childNodes.size() == 1) {
            return childNodes.get(0);
        }
        if (childNodes.size() == 0) {
            return null;
        }
        throw new ParseException("Expected to find one child <" + tagName + "> in <" + parentNode.getNodeName() + "> but found " + childNodes.size());
    }

    private static List<Node> getChildNodes(Node parentNode, String tagName) {
        NodeList childNodes = parentNode.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(tagName)) continue;
            list.add(child);
        }
        return list;
    }

    private static String getServerXmlFile() {
        if (devMode) {
            return DEV_MODE_SERVER_XML;
        }
        return "../conf/server.xml";
    }

    private static String getJiraApplicationProperties() {
        if (devMode) {
            return "jira-components/jira-core/src/main/resources/jira-application.properties";
        }
        return "../atlassian-jira/WEB-INF/classes/jira-application.properties";
    }

    public static Settings reloadDbConfig(String jiraHome) throws IOException {
        Settings settings = new Settings();
        settings.setJiraHome(jiraHome);
        SettingsLoader.loadDbConfig(settings);
        return settings;
    }
}

