/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator;

import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SettingsLoader;
import com.atlassian.jira.configurator.console.ConfiguratorConsole;
import com.atlassian.jira.configurator.gui.ConfiguratorFrame;
import com.atlassian.jira.exception.ParseException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Configurator {
    private static Settings settings;
    private static boolean consoleMode;

    public static void main(String[] args) {
        Configurator.parseArguments(args);
        Configurator.loadCurrentSettings();
        if (consoleMode) {
            Configurator.startConsole();
        } else {
            Configurator.startGui();
        }
    }

    private static void startConsole() {
        ConfiguratorConsole console = new ConfiguratorConsole();
        console.setSettings(settings);
        console.start();
    }

    private static void startGui() {
        ConfiguratorFrame configuratorFrame = new ConfiguratorFrame();
        configuratorFrame.setLocationRelativeTo(null);
        configuratorFrame.setTitle("JIRA Configuration Tool");
        try {
            configuratorFrame.setSettings(settings);
        }
        catch (ParseException e) {
            Configurator.showWarningDialog("Unable to fully parse the current JDBC settings. Some settings may be blank.\n" + e.getMessage());
        }
        configuratorFrame.setVisible(true);
    }

    private static void parseArguments(String[] args) {
        for (String arg : args) {
            if (!"-c".equals(arg) && !"--console".equals(arg)) continue;
            consoleMode = true;
        }
    }

    public static void saveSettings(Settings newSettings) throws IOException {
        SettingsLoader.saveSettings(newSettings);
        settings = newSettings;
    }

    private static void loadCurrentSettings() {
        try {
            settings = SettingsLoader.loadCurrentSettings();
        }
        catch (IOException e) {
            Configurator.showErrorDialogAndExit("IO Exception occurred while trying to load settings.\n" + e.getMessage());
        }
        catch (SAXException e) {
            Configurator.showErrorDialogAndExit("SAX Exception occurred while trying to load settings.\n" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            Configurator.showErrorDialogAndExit("Parser Configuration Exception occurred while trying to load settings.\n" + e.getMessage());
        }
        catch (ParseException e) {
            Configurator.showErrorDialogAndExit("Parse Exception occurred while trying to load settings.\n" + e.getMessage());
        }
    }

    private static void showErrorDialogAndExit(String message) {
        System.err.println(message);
        JOptionPane.showMessageDialog(null, message, "Fatal Error", 0);
        System.exit(1);
    }

    private static void showWarningDialog(String message) {
        System.err.println(message);
        JOptionPane.showMessageDialog(null, message, "Warning", 2);
    }

    public static boolean settingsEqual(Settings newSettings) {
        return settings.equals(newSettings);
    }

    static {
        consoleMode = false;
    }
}

