/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;

public interface IndexWriterConfiguration {
    public WriterSettings getInteractiveSettings();

    public WriterSettings getBatchSettings();

    public static class PropertiesAdaptor
    implements IndexWriterConfiguration {
        private final ApplicationProperties properties;
        private final WriterSettings batch = new WriterSettings(){

            @Override
            public int getMaxBufferedDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.batch.maxbuffereddocs", (int)Default.BATCH.getMaxBufferedDocs());
            }

            @Override
            public int getMergeFactor() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.batch.mergefactor", (int)Default.BATCH.getMergeFactor());
            }

            @Override
            public int getMaxMergeDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.batch.maxmergedocs", (int)Default.BATCH.getMaxMergeDocs());
            }

            @Override
            public int getMaxFieldLength() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.maxfieldlength", (int)Default.INTERACTIVE.getMaxFieldLength());
            }
        };
        private final WriterSettings interactive = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.interactive.mergefactor", (int)Default.INTERACTIVE.getMergeFactor());
            }

            @Override
            public int getMaxMergeDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.interactive.maxmergedocs", (int)Default.INTERACTIVE.getMaxMergeDocs());
            }

            @Override
            public int getMaxBufferedDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.interactive.maxbuffereddocs", (int)Default.INTERACTIVE.getMaxBufferedDocs());
            }

            @Override
            public int getMaxFieldLength() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)PropertiesAdaptor.this.properties, (String)"jira.index.maxfieldlength", (int)Default.INTERACTIVE.getMaxFieldLength());
            }
        };

        public PropertiesAdaptor(@NotNull ApplicationProperties properties) {
            this.properties = (ApplicationProperties)Assertions.notNull((String)"properties", (Object)properties);
        }

        @Override
        public WriterSettings getBatchSettings() {
            return this.batch;
        }

        @Override
        public WriterSettings getInteractiveSettings() {
            return this.interactive;
        }
    }

    public static abstract class WriterSettings {
        public IndexWriterConfig getWriterConfiguration(Analyzer analyser) {
            IndexWriterConfig luceneConfig = new IndexWriterConfig(DefaultIndexManager.LUCENE_VERSION, analyser);
            luceneConfig.setMergePolicy((MergePolicy)new TieredMergePolicy());
            luceneConfig.setMaxBufferedDocs(this.getMaxBufferedDocs());
            return luceneConfig;
        }

        public abstract int getMaxBufferedDocs();

        public abstract int getMergeFactor();

        public abstract int getMaxMergeDocs();

        public abstract int getMaxFieldLength();
    }

    public static final class Default {
        static final int MAX_FIELD_LENGTH = IndexWriter.DEFAULT_MAX_FIELD_LENGTH;
        public static final WriterSettings BATCH = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 50;
            }

            @Override
            public int getMaxMergeDocs() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return MAX_FIELD_LENGTH;
            }
        };
        public static final WriterSettings INTERACTIVE = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 4;
            }

            @Override
            public int getMaxMergeDocs() {
                return 5000;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return MAX_FIELD_LENGTH;
            }
        };
    }
}

