/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssueConstantsManager<T extends IssueConstant> {
    protected final ConstantsManager constantsManager;
    protected final OfBizDelegator ofBizDelegator;
    protected final IssueIndexManager issueIndexManager;

    public AbstractIssueConstantsManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager) {
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueIndexManager = issueIndexManager;
    }

    protected GenericValue createConstant(Map<String, Object> fields) {
        return this.ofBizDelegator.createValue(this.getIssueConstantField(), fields);
    }

    protected long getMaxSequenceNo() {
        long maxSequence = 0L;
        List transform = Lists.transform(this.getAllValues(), (Function)new Function<T, GenericValue>(){

            public GenericValue apply(T from) {
                return from.getGenericValue();
            }
        });
        for (GenericValue genericValue : transform) {
            long thisSequence = genericValue.getLong("sequence");
            if (thisSequence <= maxSequence) continue;
            maxSequence = thisSequence;
        }
        return maxSequence;
    }

    protected String getNextStringId() throws GenericEntityException {
        return EntityUtils.getNextStringId(this.getIssueConstantField());
    }

    protected void removeConstant(String fieldName, T constant, String newId) throws GenericEntityException, IndexException {
        List<GenericValue> matchingIssues = this.getMatchingIssues(constant);
        for (GenericValue issue : matchingIssues) {
            issue.set(fieldName, (Object)newId);
            this.issueIndexManager.reIndex(issue);
        }
        this.ofBizDelegator.storeAll(matchingIssues);
        GenericValue constantGv = constant.getGenericValue();
        String id = constantGv.getString("id");
        constantGv.set("id", (Object)new Long(id));
        this.removePropertySet(constantGv);
        constantGv.set("id", (Object)id);
        constantGv.remove();
        this.clearCaches();
        this.postProcess(constant);
    }

    protected void removePropertySet(GenericValue constantGv) {
        OFBizPropertyUtils.removePropertySet(constantGv);
    }

    protected void postProcess(T constant) {
    }

    protected void clearCaches() {
    }

    protected abstract String getIssueConstantField();

    protected List<GenericValue> getMatchingIssues(T constant) throws GenericEntityException {
        List matchingIssues = constant.getGenericValue().getRelated("ChildIssue");
        if (matchingIssues == null) {
            matchingIssues = Collections.EMPTY_LIST;
        }
        return matchingIssues;
    }

    protected abstract List<T> getAllValues();

    protected void moveUp(T constant) {
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>();
        for (IssueConstant cons : this.getAllValues()) {
            GenericValue value = cons.getGenericValue();
            if (cons.getId().equals(constant.getId()) && reordered.size() == 0) break;
            if (cons.getId().equals(constant.getId())) {
                reordered.add(reordered.size() - 1, value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
    }

    protected void moveDown(T constant) {
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>();
        Iterator<T> iterator = this.getAllValues().iterator();
        while (iterator.hasNext()) {
            IssueConstant cons = (IssueConstant)iterator.next();
            GenericValue value = cons.getGenericValue();
            if (cons.getId().equals(constant.getId()) && !iterator.hasNext()) break;
            if (cons.getId().equals(constant.getId())) {
                reordered.add(((IssueConstant)iterator.next()).getGenericValue());
                reordered.add(value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
    }

    private void storeAndClearCaches(List<GenericValue> reordered) {
        for (int i = 0; i < reordered.size(); ++i) {
            GenericValue value = reordered.get(i);
            value.set("sequence", (Object)new Long(i + 1));
        }
        this.ofBizDelegator.storeAll(reordered);
        this.clearCaches();
    }
}

