/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.AbstractBulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.issue.bulkedit.WorkflowTransitionKey;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class BulkWorkflowTransitionOperation
extends AbstractBulkOperation
implements BulkOperation {
    protected static final Logger log = Logger.getLogger(BulkWorkflowTransitionOperation.class);
    public static final String NAME = "BulkWorkflowTransition";
    public static final String NAME_KEY = "bulk.workflowtransition.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.workflowtransition.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.workflowtransition.cannotperform";
    private final WorkflowManager workflowManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final FieldLayoutManager fieldLayoutManager;

    public BulkWorkflowTransitionOperation(WorkflowManager workflowManager, IssueWorkflowManager issueWorkflowManager, FieldLayoutManager fieldLayoutManager) {
        this.workflowManager = workflowManager;
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (Issue issue : selectedIssues) {
            Collection availableActions = this.issueWorkflowManager.getAvailableActions(issue);
            if (availableActions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void perform(BulkEditBean bulkEditBean, User remoteUser) throws Exception {
        int actionDescriptorId = this.getActionDescriptor(bulkEditBean.getSelectedWFTransitionKey()).getId();
        WorkflowTransitionUtil workflowTransitionUtil = JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
        workflowTransitionUtil.setAction(actionDescriptorId);
        for (MutableIssue issue : bulkEditBean.getSelectedIssues()) {
            HashMap<String, Boolean> additionalInputs = new HashMap<String, Boolean>();
            Map selectedActions = bulkEditBean.getActions();
            if (selectedActions != null && selectedActions.values() != null) {
                for (BulkEditAction bulkEditAction : bulkEditBean.getActions().values()) {
                    OrderableField field = bulkEditAction.getField();
                    FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(field);
                    if (fieldLayoutItem == null) continue;
                    if ("comment".equals(field.getId())) {
                        ((CommentSystemField)field).populateAdditionalInputs(bulkEditBean.getFieldValuesHolder(), additionalInputs);
                        continue;
                    }
                    field.updateIssue(fieldLayoutItem, issue, bulkEditBean.getFieldValuesHolder());
                }
            }
            GenericValue projectGV = issue.getProject();
            BulkWorkflowProgressAware bulkWorkflowProgressAware = new BulkWorkflowProgressAware(remoteUser, actionDescriptorId, issue, projectGV);
            additionalInputs.put("sendBulkNotification", bulkEditBean.isSendBulkNotification());
            bulkWorkflowProgressAware.setAdditionalInputs(additionalInputs);
            this.workflowManager.doWorkflowAction((WorkflowProgressAware)bulkWorkflowProgressAware);
        }
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }

    public ActionDescriptor getActionDescriptor(WorkflowTransitionKey workflowTransitionKey) {
        String workflowName = workflowTransitionKey.getWorkflowName();
        String actionDescriptorId = workflowTransitionKey.getActionDescriptorId();
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        return workflow.getDescriptor().getAction(Integer.parseInt(actionDescriptorId));
    }

    static class BulkWorkflowProgressAware
    implements WorkflowProgressAware {
        private User remoteUser;
        private int actionId;
        private MutableIssue issue;
        private GenericValue projectGV;
        private Map additionalInputs;
        private boolean hasError;

        public BulkWorkflowProgressAware(User remoteUser, int actionId, MutableIssue issue, GenericValue projectGV) {
            this.remoteUser = remoteUser;
            this.actionId = actionId;
            this.issue = issue;
            this.projectGV = projectGV;
        }

        public User getRemoteUser() {
            return this.remoteUser;
        }

        public int getAction() {
            return this.actionId;
        }

        public void setAction(int action) {
            this.actionId = action;
        }

        public void addErrorMessage(String error) {
            this.hasError = true;
        }

        public void addError(String name, String error) {
            this.hasError = true;
        }

        public boolean hasError() {
            return this.hasError;
        }

        public Map getAdditionalInputs() {
            return this.additionalInputs;
        }

        public void setAdditionalInputs(Map additionalInputs) {
            this.additionalInputs = additionalInputs;
        }

        public MutableIssue getIssue() throws Exception {
            return this.issue;
        }

        public GenericValue getProject() throws Exception {
            return this.projectGV;
        }
    }
}

