/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.NullBackupProgressMonitor;
import com.atlassian.core.util.DataUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.admin.export.EntitiesExporter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.dataimport.ExportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.bc.dataimport.ExportStartedEvent;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelReader;

public class DefaultExportService
implements ExportService {
    private static final Logger LOG = Logger.getLogger(DefaultExportService.class);
    public static final String ACTIVEOBJECTS_XML = "activeobjects.xml";
    public static final String ENTITIES_XML = "entities.xml";
    private final DelegatorInterface genericDelegator;
    private final EntitiesExporter entitiesExporter;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;

    public DefaultExportService(DelegatorInterface genericDelegator, EntitiesExporter entitiesExporter, I18nHelper.BeanFactory i18nFactory, EventPublisher eventPublisher) {
        this.genericDelegator = genericDelegator;
        this.entitiesExporter = entitiesExporter;
        this.i18nFactory = i18nFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public ServiceOutcome<Void> export(User loggedInUser, String filename, TaskProgressSink taskProgressSink) {
        return this.export(loggedInUser, filename, ExportService.Style.NORMAL, taskProgressSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ServiceOutcome<Void> export(User loggedInUser, String filename, ExportService.Style style, TaskProgressSink taskProgressSink) {
        this.eventPublisher.publish((Object)new ExportStartedEvent(loggedInUser, filename));
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        ZipOutputStream zip = null;
        try {
            zip = this.getZipOutputStream(filename);
            try {
                this.exportJIRA(loggedInUser, style, zip);
                this.exportActiveObjects(zip);
                ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.ok(null);
                this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, filename, outcome));
                ServiceOutcomeImpl<Object> serviceOutcomeImpl = outcome;
                return serviceOutcomeImpl;
            }
            catch (GenericEntityException e) {
                block11: {
                    if (e.getMessage() == null || e.getMessage().indexOf("invalid XML character") == -1) break block11;
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                    ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                    this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, filename, outcome));
                    ServiceOutcomeImpl<Object> serviceOutcomeImpl = outcome;
                    IOUtils.closeQuietly((OutputStream)zip);
                    return serviceOutcomeImpl;
                }
                ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
                this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, filename, outcome));
                ServiceOutcomeImpl<Void> serviceOutcomeImpl = outcome;
                IOUtils.closeQuietly((OutputStream)zip);
                return serviceOutcomeImpl;
            }
            catch (ActiveObjectsImportExportException e) {
                LOG.error((Object)"Error during Active Objects Backup", (Throwable)e);
                ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.export.backup.activeobjects.exception", e.getPluginInformation().getPluginName()));
                this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, filename, outcome));
                ServiceOutcomeImpl<Void> serviceOutcomeImpl = outcome;
                IOUtils.closeQuietly((OutputStream)zip);
                return serviceOutcomeImpl;
                {
                    catch (IOException e2) {
                        LOG.error((Object)"Error during XML backup.", (Throwable)e2);
                        outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", filename));
                        this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, filename, outcome));
                        ServiceOutcomeImpl<Void> serviceOutcomeImpl2 = outcome;
                        return serviceOutcomeImpl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceOutcome<Void> exportForDevelopment(User loggedInUser, String xmlFilename, TaskProgressSink taskProgressSink) {
        ExportService.Style style = ExportService.Style.NORMAL;
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        OutputStream xml = null;
        try {
            xml = this.getXmlOutputStream(xmlFilename);
            try {
                this.exportJIRA(loggedInUser, style, xml);
                ServiceOutcomeImpl<Object> serviceOutcomeImpl = ServiceOutcomeImpl.ok(null);
                return serviceOutcomeImpl;
            }
            catch (GenericEntityException e) {
                ServiceOutcomeImpl<Void> serviceOutcomeImpl;
                block9: {
                    if (e.getMessage() == null || e.getMessage().indexOf("invalid XML character") == -1) break block9;
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                    ServiceOutcomeImpl<Object> serviceOutcomeImpl2 = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                    IOUtils.closeQuietly((OutputStream)xml);
                    return serviceOutcomeImpl2;
                }
                try {
                    serviceOutcomeImpl = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
                }
                catch (IOException e2) {
                    LOG.error((Object)"Error during XML backup.", (Throwable)e2);
                    ServiceOutcomeImpl<Void> serviceOutcomeImpl3 = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", xmlFilename));
                    return serviceOutcomeImpl3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)xml);
                return serviceOutcomeImpl;
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)xml);
        }
    }

    private void exportJIRA(User loggedInUser, ExportService.Style style, OutputStream out) throws GenericEntityException, IOException {
        ModelReader reader = this.genericDelegator.getModelReader();
        Collection ec = reader.getEntityNames();
        TreeSet<String> entityNames = new TreeSet<String>(ec);
        int numberOfEntities = entityNames.size();
        LOG.debug((Object)("numberOfEntities = " + numberOfEntities));
        EntityXmlWriter entityWriter = style.getEntityXmlWriter();
        long start = System.currentTimeMillis();
        long entitiesWritten = this.entitiesExporter.exportEntities(out, entityNames, entityWriter, loggedInUser);
        LOG.info((Object)("Data export completed in " + (System.currentTimeMillis() - start) + "ms. Wrote " + entitiesWritten + " entities to export in memory."));
    }

    private void exportActiveObjects(ZipOutputStream zip) throws IOException {
        Backup activeObjects = this.getActiveObjectsBackup();
        if (activeObjects == null) {
            LOG.error((Object)"Could not find ActiveObjects in OSGi fairy land. Plugins using ActiveObjects have not been backed up.");
        } else {
            zip.putNextEntry(new ZipEntry(ACTIVEOBJECTS_XML));
            LOG.info((Object)"Attempting to save the Active Objects Backup");
            try {
                activeObjects.save((OutputStream)zip, NullBackupProgressMonitor.INSTANCE);
            }
            catch (NoSuchMethodError ex) {
                String javaRuntimeVersion = System.getProperty("java.runtime.version");
                String message = "Error exporting Active Objects. You must run JRE 1.6_18 or higher. java.runtime.version: " + javaRuntimeVersion;
                LOG.error((Object)message, (Throwable)ex);
                throw new NoSuchMethodError(message);
            }
            LOG.info((Object)"Finished saving the Active Objects Backup");
        }
    }

    protected Backup getActiveObjectsBackup() {
        return ComponentManager.getOSGiComponentInstanceOfType(Backup.class);
    }

    protected ZipOutputStream getZipOutputStream(String filename) throws IOException {
        String zipFileName = DataUtils.getZipFilename((String)filename);
        ZipOutputStream out = new ZipOutputStream(FileUtils.openOutputStream((File)new File(zipFileName)));
        out.putNextEntry(new ZipEntry(ENTITIES_XML));
        return out;
    }

    protected OutputStream getXmlOutputStream(String filename) throws IOException {
        String xmlFileName = DataUtils.getXmlFilename((String)filename);
        FileOutputStream out = FileUtils.openOutputStream((File)new File(xmlFileName));
        return out;
    }
}

