/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.BooleanValidator;
import com.atlassian.validation.IntegerValidator;
import com.atlassian.validation.NonValidator;
import com.atlassian.validation.Validator;
import com.atlassian.validation.ValidatorFactory;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;

public class ApplicationPropertyMetadata {
    private static final Map<String, Validator> DEFAULT_VALIDATORS_BY_TYPE = new HashMap<String, Validator>();
    private String key;
    private String type;
    private String defaultValue;
    private Supplier<? extends Validator> validator;
    private boolean userEditable;
    private boolean requiresRestart;
    private String name;
    private String desc;
    private ApplicationPropertyEnumerator enumerator;

    private static Supplier<Validator> validatorResolver(final String type) {
        return new LazyReference<Validator>(){

            protected Validator create() throws Exception {
                Validator validator = (Validator)DEFAULT_VALIDATORS_BY_TYPE.get(type);
                if (validator == null) {
                    validator = new NonValidator();
                }
                return validator;
            }
        };
    }

    public ApplicationPropertyMetadata(String key, String type, String defaultValue, Supplier<? extends Validator> validatorSupplier, boolean userEditable, boolean requiresRestart) {
        this(key, type, defaultValue, validatorSupplier, userEditable, requiresRestart, null, null, null);
    }

    public ApplicationPropertyMetadata(String key, String type, String defaultValue, String validatorName, boolean userEditable, boolean requiresRestart, String name, String desc, ApplicationPropertyEnumerator enumerator) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.userEditable = userEditable;
        this.requiresRestart = requiresRestart;
        this.name = name;
        this.desc = desc;
        this.enumerator = enumerator;
        this.validator = validatorName == null ? ApplicationPropertyMetadata.validatorResolver(type) : new ValidatorFactory().getInstanceLazyReference(validatorName);
    }

    public ApplicationPropertyMetadata(String key, String type, String defaultValue, Supplier<? extends Validator> validatorSupplier, boolean userEditable, boolean requiresRestart, String name, String desc, ApplicationPropertyEnumerator enumerator) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.userEditable = userEditable;
        this.requiresRestart = requiresRestart;
        this.name = name;
        this.desc = desc;
        this.validator = validatorSupplier;
        this.enumerator = enumerator;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isUserEditable() {
        return this.userEditable;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Validator getValidator() {
        return (Validator)this.validator.get();
    }

    public ApplicationPropertyEnumerator getEnumerator() {
        if (!"enum".equals(this.type)) {
            throw new IllegalStateException("Tried to get enumerator for a non-enum type");
        }
        return this.enumerator;
    }

    public Validator.Result validate(String value) {
        return ((Validator)this.validator.get()).validate(value);
    }

    static {
        DEFAULT_VALIDATORS_BY_TYPE.put("string", new NonValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("uint", new IntegerValidator(0, Integer.MAX_VALUE));
        DEFAULT_VALIDATORS_BY_TYPE.put("int", new IntegerValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("boolean", new BooleanValidator());
    }
}

