/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.license.LicenseStringFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OfbizImportHandler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(OfbizImportHandler.class);
    static final String OSPROPERTY_STRING = "OSPropertyString";
    static final String OSPROPERTY_TEXT = "OSPropertyText";
    static final String OSPROPERTY_ENTRY = "OSPropertyEntry";
    static final String OSPROPERTY_NUMBER = "OSPropertyNumber";
    private static final String ENTITY_ENGINE_XML = "entity-engine-xml";
    private static final String SQL_STATE_DEADLOCK = "40001";
    private static final int MAX_SQL_DEADLOCK_RETRIES = 3;
    private final OfBizDelegator ofBizDelegator;
    private final Executor executor;
    private TaskProgressSink taskProgressSink = TaskProgressSink.NULL_SINK;
    private final LicenseStringFactory licenseStringFactory;
    private final IndexPathManager indexPathManager;
    private final AttachmentPathManager attachmentPathManager;
    private final Map<String, String> osPropertyStringMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyTextMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyNumberMap = new HashMap<String, String>();
    private final AtomicReference<Throwable> importError = new AtomicReference();
    private final Map<String, String> licenseIds = new HashMap<String, String>();
    private StringBuffer textBuffer;
    private boolean hasRootElement = false;
    private String inEntity = null;
    private GenericValue value;
    private boolean createEntities;
    private boolean useDefaultIndexPath;
    private boolean useDefaultAttachmentPath;
    private long entityCount;
    private String buildNumberId = null;
    private String buildNumber = null;
    private String licenseString;
    private String indexPath;
    private String indexPathId;
    private String attachmentPath;
    private String attachmentPathId;
    private String indexDefaultId;
    private String attachmentDefaultId;
    private boolean useDefaultPaths;

    OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor, LicenseStringFactory licenseStringFactory, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager) {
        this(ofBizDelegator, executor, licenseStringFactory, indexPathManager, attachmentPathManager, false);
    }

    public OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor, LicenseStringFactory licenseStringFactory, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager, boolean useDefaultPaths) {
        this.ofBizDelegator = ofBizDelegator;
        this.executor = executor;
        this.licenseStringFactory = (LicenseStringFactory)Assertions.notNull((String)"licenseStringFactory", (Object)licenseStringFactory);
        this.indexPathManager = indexPathManager;
        this.attachmentPathManager = attachmentPathManager;
        this.createEntities = false;
        this.useDefaultPaths = useDefaultPaths;
    }

    @Override
    public void startDocument() throws SAXException {
        log.debug((Object)"Starting Document");
        this.entityCount = 0L;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.hasRootElement) {
            throw new SAXException("XML file ended too early.  There was no </entity-engine-xml> tag.");
        }
        this.createBuildNumber();
        this.createLicenseString();
        this.createIndexDefault();
        this.createAttachmentDefault();
        this.createIndexPath();
        this.createAttachmentPath();
        log.debug((Object)"Ending Document");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.importError.get() != null) {
            throw new SAXException(new Exception(this.importError.get()));
        }
        if (this.hasRootElement) {
            if (this.inEntity != null) {
                if (this.value == null) {
                    throw new SAXException("Somehow we have got inside an Entity without creating a GenericValue for it.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read opening subelement " + qName + " of entity " + this.value.getEntityName()));
                }
                this.textBuffer = null;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read opening " + qName + " element"));
                }
                this.inEntity = qName;
                this.value = this.ofBizDelegator.makeValue(qName);
                ModelEntity modelEntity = this.value.getModelEntity();
                Iterator i = modelEntity.getFieldsIterator();
                while (i.hasNext()) {
                    ModelField modelField = (ModelField)i.next();
                    String name = modelField.getName();
                    String attr = attributes.getValue(name);
                    if (attr == null) continue;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Setting attribute " + name + " with value " + attr));
                        }
                        this.value.setString(name, attr);
                    }
                    catch (RuntimeException e) {
                        log.error((Object)("Failed to set attribute '" + qName + "." + name + "' with value '" + attr + "'. Error: " + e.getMessage()));
                        throw e;
                    }
                }
                this.recordElementsInfo(qName, attributes);
                if (this.isPropertyString(qName)) {
                    this.setDefaultPaths(attributes);
                }
                if (this.isPropertyNumber(qName)) {
                    this.setUseDefaultPaths(attributes);
                }
            }
        } else if (ENTITY_ENGINE_XML.equals(qName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Read opening ROOT element");
            }
            this.hasRootElement = true;
        } else {
            throw new SAXException("The XML document does not contain the <entity-engine-xml> root element or it was closed too early.");
        }
    }

    private void setDefaultPaths(Attributes attributes) {
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.indexPathId)) {
            this.value.setString("value", this.indexPathManager.getDefaultIndexRootPath());
        }
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.attachmentPathId)) {
            this.value.setString("value", this.attachmentPathManager.getDefaultAttachmentPath());
        }
    }

    private void setUseDefaultPaths(Attributes attributes) {
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.indexDefaultId)) {
            this.value.setString("value", "1");
        }
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.attachmentDefaultId)) {
            this.value.setString("value", "1");
        }
    }

    void createBuildNumber() {
        if (this.buildNumberId != null) {
            this.buildNumber = this.osPropertyStringMap.get(this.buildNumberId);
        }
    }

    private void createAttachmentDefault() {
        if (this.useDefaultPaths) {
            this.useDefaultAttachmentPath = true;
        } else if (this.attachmentDefaultId != null) {
            this.useDefaultAttachmentPath = "1".equals(this.osPropertyNumberMap.get(this.attachmentDefaultId));
        }
    }

    private void createIndexDefault() {
        if (this.useDefaultPaths) {
            this.useDefaultIndexPath = true;
        } else if (this.indexDefaultId != null) {
            this.useDefaultIndexPath = "1".equals(this.osPropertyNumberMap.get(this.indexDefaultId));
        }
    }

    void createIndexPath() {
        if (this.useDefaultIndexPath) {
            this.indexPath = this.indexPathManager.getDefaultIndexRootPath();
        } else if (this.indexPathId != null) {
            this.indexPath = this.osPropertyStringMap.get(this.indexPathId);
        }
    }

    void createAttachmentPath() {
        if (this.useDefaultAttachmentPath) {
            this.attachmentPath = this.attachmentPathManager.getDefaultAttachmentPath();
        } else if (this.attachmentPathId != null) {
            this.attachmentPath = this.osPropertyStringMap.get(this.attachmentPathId);
        }
    }

    void createLicenseString() {
        if (this.licenseIds.containsKey("License20")) {
            this.licenseString = this.osPropertyTextMap.get(this.licenseIds.get("License20"));
        } else if (this.licenseIds.containsKey("License Hash 1 Text") && this.licenseIds.containsKey("License Message Text")) {
            String hash = this.osPropertyTextMap.get(this.licenseIds.get("License Hash 1 Text"));
            String msg = this.osPropertyTextMap.get(this.licenseIds.get("License Message Text"));
            this.licenseString = this.licenseStringFactory.create(msg, hash);
        } else if (this.licenseIds.containsKey("License Hash 1") && this.licenseIds.containsKey("License Message")) {
            String hash = this.osPropertyStringMap.get(this.licenseIds.get("License Hash 1"));
            String msg = this.osPropertyStringMap.get(this.licenseIds.get("License Message"));
            this.licenseString = this.licenseStringFactory.create(msg, hash);
        }
    }

    void recordElementsInfo(String qName, Attributes attributes) {
        this.recordProperties(qName, attributes, OSPROPERTY_STRING, this.osPropertyStringMap);
        this.recordProperties(qName, attributes, OSPROPERTY_TEXT, this.osPropertyTextMap);
        this.recordProperties(qName, attributes, OSPROPERTY_NUMBER, this.osPropertyNumberMap);
        if (this.isPropertyEntry(qName, attributes, "jira.version.patched")) {
            this.buildNumberId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "License20")) {
            this.licenseIds.put("License20", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "License Hash 1 Text")) {
            this.licenseIds.put("License Hash 1 Text", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "License Message Text")) {
            this.licenseIds.put("License Message Text", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "License Hash 1")) {
            this.licenseIds.put("License Hash 1", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "License Message")) {
            this.licenseIds.put("License Message", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.index")) {
            this.indexPathId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.index.use.default.directory")) {
            this.indexDefaultId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.attachments")) {
            this.attachmentPathId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.attachments.use.default.directory")) {
            this.attachmentDefaultId = attributes.getValue("id");
        }
    }

    private void recordProperties(String qName, Attributes attributes, String entityName, Map<String, String> store) {
        if (entityName.equals(qName)) {
            String id = attributes.getValue("id");
            String value = attributes.getValue("value");
            if (id != null && value != null) {
                store.put(id, value);
            }
        }
    }

    private boolean isPropertyEntry(String qName, Attributes attributes, String property) {
        return StringUtils.equals((String)OSPROPERTY_ENTRY, (String)qName) && StringUtils.equals((String)property, (String)attributes.getValue("propertyKey")) && StringUtils.isNotBlank((String)attributes.getValue("id"));
    }

    private boolean isPropertyString(String qName) {
        return StringUtils.equals((String)OSPROPERTY_STRING, (String)qName);
    }

    private boolean isPropertyNumber(String qName) {
        return StringUtils.equals((String)OSPROPERTY_NUMBER, (String)qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasRootElement) {
            if (ENTITY_ENGINE_XML.equals(qName)) {
                log.debug((Object)"Read closing ROOT element");
                this.hasRootElement = false;
            } else {
                if (this.inEntity == null) {
                    throw new SAXException("There is no entity set");
                }
                if (this.inEntity.equals(qName)) {
                    log.debug((Object)("Read closing " + qName + " element"));
                    ++this.entityCount;
                    if (this.createEntities) {
                        this.createValue(this.value);
                        this.taskProgressSink.makeProgress(this.entityCount, "data.import.store.entities", "data.import.store.entities.progress");
                    }
                    this.value = null;
                    this.inEntity = null;
                } else {
                    log.debug((Object)("Read closing subelement " + qName + " of entity " + this.value.getEntityName()));
                    if (this.textBuffer != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Setting attribute " + qName + " with value " + this.textBuffer.toString()));
                        }
                        this.value.setString(qName, this.textBuffer.toString());
                        this.textBuffer = null;
                    }
                }
            }
        } else {
            throw new SAXException("How did we get here an exception should already have been thrown");
        }
    }

    private void createValue(final GenericValue value) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OfbizImportHandler.this.createWithDeadlockRetry(value);
                }
                catch (Error e) {
                    log.error((Object)("Exception importing entity: " + e), (Throwable)e);
                    OfbizImportHandler.this.importError.set(e);
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)("Exception importing entity: " + e), (Throwable)e);
                    OfbizImportHandler.this.importError.set(new DataAccessException((Throwable)e));
                }
            }
        });
    }

    void createWithDeadlockRetry(GenericValue value) throws GenericEntityException {
        boolean deadlocked;
        int attempts = 0;
        do {
            deadlocked = false;
            try {
                value.create();
            }
            catch (GenericEntityException e) {
                String sqlState = OfbizImportHandler.getSqlState(e);
                if (++attempts <= 3 && sqlState != null && sqlState.equals(SQL_STATE_DEADLOCK)) {
                    deadlocked = true;
                    continue;
                }
                throw e;
            }
        } while (deadlocked);
    }

    private static String getSqlState(GenericEntityException e) {
        Throwable ex = e.getNested();
        while (ex != null) {
            if (ex instanceof SQLException) {
                return ((SQLException)ex).getSQLState();
            }
            if (ex instanceof GenericEntityException) {
                ex = ((GenericEntityException)ex).getNested();
                continue;
            }
            ex = null;
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    public void setCreateEntities(boolean createEntities) {
        this.createEntities = createEntities;
    }

    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public Throwable getImportError() {
        return this.importError.get();
    }

    public boolean isUseDefaultIndexPath() {
        return this.useDefaultIndexPath;
    }

    public boolean isUseDefaultAttachmentPath() {
        return this.useDefaultAttachmentPath;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public String getAttachmentPath() {
        return this.attachmentPath;
    }
}

