/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfigurationPropertyImpl;
import com.atlassian.configurable.ValuesGenerator;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public class ValuesGeneratorObjectConfigurationProperty
extends ObjectConfigurationPropertyImpl {
    private static final Logger log = Logger.getLogger(ValuesGeneratorObjectConfigurationProperty.class);
    private final ValuesGenerator valuesGenerator;

    public ValuesGeneratorObjectConfigurationProperty(String name, String description, String defaultValue, int type, String valueGeneratorClass, String enabledConditionClass) {
        this(name, description, defaultValue, type, valueGeneratorClass, enabledConditionClass, ValuesGeneratorObjectConfigurationProperty.class.getClassLoader());
    }

    public ValuesGeneratorObjectConfigurationProperty(String name, String description, String defaultValue, int type, String valueGeneratorClass, String enabledConditionClass, ClassLoader classLoader) {
        super(name, description, defaultValue, type, enabledConditionClass, classLoader);
        ValuesGenerator valuesGenerator = ValuesGenerator.NONE;
        try {
            valuesGenerator = (ValuesGenerator)classLoader.loadClass(valueGeneratorClass).newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Could not create class: " + valueGeneratorClass), (Throwable)e);
        }
        this.valuesGenerator = valuesGenerator;
    }

    @Override
    protected Map getInternalValues(Map userParams) {
        Map values = this.valuesGenerator.getValues(userParams);
        if (values == null) {
            return Collections.EMPTY_MAP;
        }
        return values;
    }
}

