/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.sal.api.user.UserManager;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseUrlCheckCondition
implements UrlReadingCondition {
    private static final String BASEURL_CHECK_RESOURCES_QUERY_PARAM = "baseurl-check-resources";
    private final UserManager userManager;

    @Autowired
    public BaseUrlCheckCondition(@Nonnull @ComponentImport UserManager userManager) {
        this.userManager = Objects.requireNonNull(userManager);
    }

    public void init(Map<String, String> map) {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isUserSysAdmin()) {
            urlBuilder.addToQueryString(BASEURL_CHECK_RESOURCES_QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.valueOf(queryParams.get(BASEURL_CHECK_RESOURCES_QUERY_PARAM));
    }

    private boolean isUserSysAdmin() {
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
    }
}

