/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class BaseUrlCheckCondition {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public BaseUrlCheckCondition(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport GlobalPermissionManager permissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    public boolean shouldDisplay() {
        return Optional.ofNullable(this.jiraAuthenticationContext.getLoggedInUser()).map(user -> this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)).orElse(false);
    }
}

