/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.Internal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@Internal
public final class ArchivedIssueExportEvent {
    private final long issuesTotal;
    private final List<String> projectsKeys;

    public ArchivedIssueExportEvent(long issuesTotal, List<String> projectsKeys) {
        this.issuesTotal = issuesTotal;
        this.projectsKeys = projectsKeys == null ? Collections.emptyList() : projectsKeys;
    }

    public long getIssuesTotal() {
        return this.issuesTotal;
    }

    @Nonnull
    public List<String> getProjectsKeys() {
        return this.projectsKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedIssueExportEvent that = (ArchivedIssueExportEvent)o;
        return Objects.equals(this.issuesTotal, that.issuesTotal) && Objects.equals(this.projectsKeys, that.projectsKeys);
    }

    public int hashCode() {
        return Objects.hash(this.issuesTotal, this.projectsKeys);
    }
}

