/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.issue.field.AbstractCustomFieldEvent;
import com.atlassian.jira.event.issue.field.CustomFieldDetails;
import com.atlassian.jira.event.issue.field.CustomFieldDetailsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import javax.annotation.Nonnull;

public class CustomFieldUpdatedEvent
extends AbstractCustomFieldEvent {
    private final CustomFieldDetails originalCustomField;
    private final Long lastValueUpdate;
    private final Long issuesWithValue;
    private final Long numberOfProjects;
    private final Long numberOfScreens;

    @Internal
    public CustomFieldUpdatedEvent(@Nonnull CustomField customField, @Nonnull CustomField originalCustomField) {
        this(customField, originalCustomField, -1L);
    }

    @Internal
    public CustomFieldUpdatedEvent(@Nonnull CustomField customField, @Nonnull CustomField originalCustomField, @Nonnull Long numberOfScreens) {
        super(customField);
        this.originalCustomField = new CustomFieldDetailsImpl(originalCustomField);
        this.lastValueUpdate = customField.getLastValueUpdate() != null ? Long.valueOf(customField.getLastValueUpdate().getTime()) : null;
        this.issuesWithValue = customField.getIssuesWithValue();
        this.numberOfProjects = customField.getAssociatedProjectObjects().size();
        this.numberOfScreens = numberOfScreens;
    }

    public Long getLastValueUpdate() {
        return this.lastValueUpdate;
    }

    public Long getIssuesWithValue() {
        return this.issuesWithValue;
    }

    public Long getNumberOfProjects() {
        return this.numberOfProjects;
    }

    public Long getNumberOfScreens() {
        return this.numberOfScreens;
    }

    public CustomFieldDetails getOriginalCustomField() {
        return this.originalCustomField;
    }
}

