/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;

public class GeneralConfigurations {
    private final Boolean allowUnassigned;
    private final String baseUrl;
    private final Boolean captcha;
    private final Boolean commentVisibility;
    private final String contactAdministratorsMessage;
    private final Boolean criteriaAutoUpdate;
    private final Boolean csvExportDialogDisabled;
    private final Boolean customFieldHtmlEnabled;
    private final String defaultLocale;
    private final String defaultTimezone;
    private final String emailFromHeaderFormat;
    private final String emailVisibility;
    private final Boolean emptyJqlReturnsNoDataEnabled;
    private final Boolean excludePrecedenceHeader;
    private final Boolean externalUserManagement;
    private final String favouriteFiltersGadgetMaxTimeout;
    private final Boolean globalSharing;
    private final String ieMimeSniffer;
    private final String indexingLanguage;
    private final Boolean inlineEdit;
    private final String introduction;
    private final Boolean issueCommentReactionsEnabled;
    private final Boolean issuePicker;
    private final Boolean jqlAutocomplete;
    private final String logoutConfirm;
    private final String maxAuthenticationAttempts;
    private final String maximumLengthProjectKeys;
    private final String maximumLengthProjectNames;
    private final String mode;
    private final Boolean projectDescriptionHtmlEnabled;
    private final Boolean showContactAdministratorsForm;
    private final Boolean stackTraceEnabled;
    private final String title;
    private final Boolean useGZip;
    private final Boolean vote;
    private final Boolean watch;
    private final Boolean xsrfDialogDisplayParamsEnabled;
    public static final String I18N_KEY_ALLOW_UNASSIGNED = "admin.generalconfiguration.allow.unassigned.issues";
    public static final String I18N_KEY_BASE_URL = "admin.generalconfiguration.base.url";
    public static final String I18N_KEY_CAPTCHA = "admin.generalconfiguration.captcha.on.signup";
    public static final String I18N_KEY_COMMENT_VISIBILITY = "admin.generalconfiguration.commentlevel.visibility";
    public static final String I18N_KEY_CONTACT_ADMINISTRATORS_MESSAGE = "admin.generalconfiguration.contact.administrators.message";
    public static final String I18N_KEY_CRITERIA_AUTO_UPDATE = "jira.issuenav.criteria.update.label";
    public static final String I18N_KEY_CSV_EXPORT_DIALOG_DISABLED = "admin.generalconfiguration.csv.export.dialog.enabled.label";
    public static final String I18N_KEY_CUSTOM_FIELD_HTML_ENABLED = "admin.generalconfiguration.custom.field.html.enabled.label";
    public static final String I18N_KEY_DEFAULT_LOCALE = "admin.generalconfiguration.default.language";
    public static final String I18N_KEY_DEFAULT_TIMEZONE = "admin.generalconfiguration.default.timezone";
    public static final String I18N_KEY_EMAIL_FROM_HEADER_FORMAT = "admin.generalconfiguration.email.from.header";
    public static final String I18N_KEY_EMAIL_VISIBILITY = "admin.generalconfiguration.user.email.visibility";
    public static final String I18N_KEY_EMPTY_JQL_RETURNS_NO_DATA_ENABLED = "admin.generalconfiguration.empty.jql.returns.no.data.label";
    public static final String I18N_KEY_EXCLUDE_PRECEDENCE_HEADER = "jira.auditing.general.configuration.extra.attribute.key.enable.email.header";
    public static final String I18N_KEY_EXTERNAL_USER_MANAGEMENT = "admin.generalconfiguration.external.user.management";
    public static final String I18N_KEY_FAVOURITE_FILTERS_GADGET_MAX_TIMEOUT = "admin.generalconfiguration.favourite.filters.jql.execution.timeout.label";
    public static final String I18N_KEY_GLOBAL_SHARING = "admin.generalconfiguration.allow.public.sharing";
    public static final String I18N_KEY_IE_MIME_SNIFFER = "admin.generalconfiguration.ie.mime.sniffing";
    public static final String I18N_KEY_INDEXING_LANGUAGE = "admin.generalconfiguration.indexing.language";
    public static final String I18N_KEY_INLINE_EDIT = "admin.generalconfiguration.inline.edit";
    public static final String I18N_KEY_INTRODUCTION = "admin.common.words.introduction";
    public static final String I18N_KEY_ISSUE_COMMENT_REACTIONS_ENABLED = "admin.generalconfiguration.enable.issue.comment.reactions.label";
    public static final String I18N_KEY_ISSUE_PICKER = "admin.generalconfiguration.enable.ajax.issue.picker";
    public static final String I18N_KEY_JQL_AUTOCOMPLETE = "admin.generalconfiguration.enabled.jql.autocomplete";
    public static final String I18N_KEY_LOGOUT_CONFIRM = "admin.generalconfiguration.logout.confirmation";
    public static final String I18N_KEY_MAX_AUTHENTICATION_ATTEMPTS = "admin.generalconfiguration.maximum.authentication.attempts.allowed";
    public static final String I18N_KEY_MAXIMUM_LENGTH_PROJECT_KEYS = "admin.generalconfiguration.maximum.length.project.keys";
    public static final String I18N_KEY_MAXIMUM_LENGTH_PROJECT_NAMES = "admin.generalconfiguration.maximum.length.project.names";
    public static final String I18N_KEY_MODE = "admin.common.words.mode";
    public static final String I18N_KEY_PROJECT_DESCRIPTION_HTML_ENABLED = "admin.generalconfiguration.project.description.html.enabled.label";
    public static final String I18N_KEY_SHOW_CONTACT_ADMINISTRATORS_FORM = "admin.generalconfiguration.show.contact.administrators.form";
    public static final String I18N_KEY_STACK_TRACE_ENABLED = "admin.generalconfiguration.stacktrace";
    public static final String I18N_KEY_TITLE = "admin.common.words.title";
    public static final String I18N_KEY_USE_GZIP = "admin.generalconfiguration.use.gzip.compression";
    public static final String I18N_KEY_VOTE = "admin.generalconfiguration.voting";
    public static final String I18N_KEY_WATCH = "admin.generalconfiguration.allow.users.to.watch";
    public static final String I18N_KEY_XSRF_DIALOG_DISPLAY_PARAMS_ENABLED = "admin.generalconfiguration.xsrf.dialog.urlparams.display.label";

    private GeneralConfigurations(GeneralConfigurationsBuilder builder) {
        this.allowUnassigned = builder.allowUnassigned;
        this.baseUrl = builder.baseUrl;
        this.captcha = builder.captcha;
        this.commentVisibility = builder.commentVisibility;
        this.contactAdministratorsMessage = builder.contactAdministratorsMessage;
        this.criteriaAutoUpdate = builder.criteriaAutoUpdate;
        this.csvExportDialogDisabled = builder.csvExportDialogDisabled;
        this.customFieldHtmlEnabled = builder.customFieldHtmlEnabled;
        this.defaultLocale = builder.defaultLocale;
        this.defaultTimezone = builder.defaultTimezone;
        this.emailFromHeaderFormat = builder.emailFromHeaderFormat;
        this.emailVisibility = builder.emailVisibility;
        this.emptyJqlReturnsNoDataEnabled = builder.emptyJqlReturnsNoDataEnabled;
        this.excludePrecedenceHeader = builder.excludePrecedenceHeader;
        this.externalUserManagement = builder.externalUserManagement;
        this.favouriteFiltersGadgetMaxTimeout = builder.favouriteFiltersGadgetMaxTimeout;
        this.globalSharing = builder.globalSharing;
        this.ieMimeSniffer = builder.ieMimeSniffer;
        this.indexingLanguage = builder.indexingLanguage;
        this.inlineEdit = builder.inlineEdit;
        this.introduction = builder.introduction;
        this.issueCommentReactionsEnabled = builder.issueCommentReactionsEnabled;
        this.issuePicker = builder.issuePicker;
        this.jqlAutocomplete = builder.jqlAutocomplete;
        this.logoutConfirm = builder.logoutConfirm;
        this.maxAuthenticationAttempts = builder.maxAuthenticationAttempts;
        this.maximumLengthProjectKeys = builder.maximumLengthProjectKeys;
        this.maximumLengthProjectNames = builder.maximumLengthProjectNames;
        this.mode = builder.mode;
        this.projectDescriptionHtmlEnabled = builder.projectDescriptionHtmlEnabled;
        this.showContactAdministratorsForm = builder.showContactAdministratorsForm;
        this.stackTraceEnabled = builder.stackTraceEnabled;
        this.title = builder.title;
        this.useGZip = builder.useGZip;
        this.vote = builder.vote;
        this.watch = builder.watch;
        this.xsrfDialogDisplayParamsEnabled = builder.xsrfDialogDisplayParamsEnabled;
    }

    public static GeneralConfigurations buildFromCurrentConfigurations(ApplicationProperties applicationProperties, String introduction, ProjectService projectService) {
        return new GeneralConfigurationsBuilder().allowUnassigned(applicationProperties.getOption("jira.option.allowunassigned")).baseUrl(applicationProperties.getString("jira.baseurl")).captcha(applicationProperties.getOption("jira.option.captcha.on.signup")).commentVisibility(applicationProperties.getOption("jira.comment.level.visibility.groups")).contactAdministratorsMessage(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.contact.administrators.message"), applicationProperties.getDefaultBackedText("jira.contact.administrators.message"))).criteriaAutoUpdate(applicationProperties.getOption("jira.issuenav.criteria.autoupdate")).csvExportDialogDisabled(applicationProperties.getOption("jira.csv.export.dialog.enabled")).customFieldHtmlEnabled(applicationProperties.getOption("jira.custom.field.html.enabled")).defaultLocale(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.i18n.default.locale"), "en_AU")).defaultTimezone(applicationProperties.getString("jira.default.timezone")).emailFromHeaderFormat(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.email.fromheader.format"), applicationProperties.getDefaultBackedString("jira.email.fromheader.format"))).emailVisibility(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.option.emailvisible"), applicationProperties.getDefaultBackedString("jira.option.emailvisible"))).emptyJqlReturnsNoDataEnabled(applicationProperties.getOption("jira.empty.jql.returns.no.data.enabled")).excludePrecedenceHeader(applicationProperties.getOption("jira.option.precedence.header.exclude")).externalUserManagement(applicationProperties.getOption("jira.option.user.externalmanagement")).favouriteFiltersGadgetMaxTimeout(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("admin.generalconfiguration.favourite.filters.jql.execution.timeout"), applicationProperties.getDefaultBackedString("admin.generalconfiguration.favourite.filters.jql.execution.timeout"))).globalSharing(applicationProperties.getOption("jira.option.globalsharing")).ieMimeSniffer(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.attachment.download.mime.sniffing.workaround"), applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround"))).indexingLanguage(applicationProperties.getString("jira.i18n.language.index")).inlineEdit(applicationProperties.getOption("jira.issue.inline.edit.disabled")).introduction(GeneralConfigurations.defaultValueIfNull(introduction, applicationProperties.getText("jira.introduction"))).issueCommentReactionsEnabled(applicationProperties.getOption("jira.issue.view.comment.reactions.enabled")).issuePicker(applicationProperties.getOption("jira.ajax.autocomplete.issuepicker.enabled")).jqlAutocomplete(applicationProperties.getOption("jira.jql.autocomplete.disabled")).logoutConfirm(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.option.logoutconfirm"), applicationProperties.getDefaultBackedString("jira.option.logoutconfirm"))).maxAuthenticationAttempts(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.maximum.authentication.attempts.allowed"), applicationProperties.getDefaultBackedString("jira.maximum.authentication.attempts.allowed"))).maximumLengthProjectKeys(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.projectkey.maxlength"), String.valueOf(projectService.getMaximumKeyLength()))).maximumLengthProjectNames(GeneralConfigurations.defaultValueIfNull(applicationProperties.getString("jira.projectname.maxlength"), String.valueOf(projectService.getMaximumNameLength()))).mode(applicationProperties.getString("jira.mode")).projectDescriptionHtmlEnabled(applicationProperties.getOption("jira.project.description.html.enabled")).showContactAdministratorsForm(applicationProperties.getOption("jira.show.contact.administrators.form")).stackTraceEnabled(applicationProperties.getOption("jira.option.stacktraceOnErrorpage")).title(applicationProperties.getString("jira.title")).useGZip(applicationProperties.getOption("jira.option.web.usegzip")).vote(applicationProperties.getOption("jira.option.voting")).watch(applicationProperties.getOption("jira.option.watching")).xsrfDialogDisplayParamsEnabled(applicationProperties.getOption("jira.xsrf.dialog.display.url.params.enabled")).build();
    }

    public Boolean getAllowUnassigned() {
        return this.allowUnassigned;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getCaptcha() {
        return this.captcha;
    }

    public Boolean getCommentVisibility() {
        return this.commentVisibility;
    }

    public String getContactAdministratorsMessage() {
        return this.contactAdministratorsMessage;
    }

    public Boolean getCriteriaAutoUpdate() {
        return this.criteriaAutoUpdate;
    }

    public Boolean getCsvExportDialogDisabled() {
        return this.csvExportDialogDisabled;
    }

    public Boolean getCustomFieldHtmlEnabled() {
        return this.customFieldHtmlEnabled;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public String getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public String getEmailFromHeaderFormat() {
        return this.emailFromHeaderFormat;
    }

    public String getEmailVisibility() {
        return this.emailVisibility;
    }

    public Boolean getEmptyJqlReturnsNoDataEnabled() {
        return this.emptyJqlReturnsNoDataEnabled;
    }

    public Boolean getExcludePrecedenceHeader() {
        return this.excludePrecedenceHeader;
    }

    public Boolean getExternalUserManagement() {
        return this.externalUserManagement;
    }

    public String getFavouriteFiltersGadgetMaxTimeout() {
        return this.favouriteFiltersGadgetMaxTimeout;
    }

    public Boolean getGlobalSharing() {
        return this.globalSharing;
    }

    public String getIeMimeSniffer() {
        return this.ieMimeSniffer;
    }

    public String getIndexingLanguage() {
        return this.indexingLanguage;
    }

    public Boolean getInlineEdit() {
        return this.inlineEdit;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public Boolean getIssueCommentReactionsEnabled() {
        return this.issueCommentReactionsEnabled;
    }

    public Boolean getIssuePicker() {
        return this.issuePicker;
    }

    public Boolean getJqlAutocomplete() {
        return this.jqlAutocomplete;
    }

    public String getLogoutConfirm() {
        return this.logoutConfirm;
    }

    public String getMaxAuthenticationAttempts() {
        return this.maxAuthenticationAttempts;
    }

    public String getMaximumLengthProjectKeys() {
        return this.maximumLengthProjectKeys;
    }

    public String getMaximumLengthProjectNames() {
        return this.maximumLengthProjectNames;
    }

    public String getMode() {
        return this.mode;
    }

    public Boolean getProjectDescriptionHtmlEnabled() {
        return this.projectDescriptionHtmlEnabled;
    }

    public Boolean getShowContactAdministratorsForm() {
        return this.showContactAdministratorsForm;
    }

    public Boolean getStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getUseGZip() {
        return this.useGZip;
    }

    public Boolean getVote() {
        return this.vote;
    }

    public Boolean getWatch() {
        return this.watch;
    }

    public Boolean getXsrfDialogDisplayParamsEnabled() {
        return this.xsrfDialogDisplayParamsEnabled;
    }

    private static String defaultValueIfNull(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static class GeneralConfigurationsBuilder {
        private Boolean allowUnassigned;
        private String baseUrl;
        private Boolean captcha;
        private Boolean commentVisibility;
        private String contactAdministratorsMessage;
        private Boolean criteriaAutoUpdate;
        private Boolean csvExportDialogDisabled;
        private Boolean customFieldHtmlEnabled;
        private String defaultLocale;
        private String defaultTimezone;
        private String emailFromHeaderFormat;
        private String emailVisibility;
        private Boolean emptyJqlReturnsNoDataEnabled;
        private Boolean excludePrecedenceHeader;
        private Boolean externalUserManagement;
        private String favouriteFiltersGadgetMaxTimeout;
        private Boolean globalSharing;
        private String ieMimeSniffer;
        private String indexingLanguage;
        private Boolean inlineEdit;
        private String introduction;
        private Boolean issueCommentReactionsEnabled;
        private Boolean issuePicker;
        private Boolean jqlAutocomplete;
        private String logoutConfirm;
        private String maxAuthenticationAttempts;
        private String maximumLengthProjectKeys;
        private String maximumLengthProjectNames;
        private String mode;
        private Boolean projectDescriptionHtmlEnabled;
        private Boolean showContactAdministratorsForm;
        private Boolean stackTraceEnabled;
        private String title;
        private Boolean useGZip;
        private Boolean vote;
        private Boolean watch;
        private Boolean xsrfDialogDisplayParamsEnabled;

        public GeneralConfigurationsBuilder allowUnassigned(Boolean allowUnassigned) {
            this.allowUnassigned = allowUnassigned;
            return this;
        }

        public GeneralConfigurationsBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public GeneralConfigurationsBuilder captcha(Boolean captcha) {
            this.captcha = captcha;
            return this;
        }

        public GeneralConfigurationsBuilder commentVisibility(Boolean commentVisibility) {
            this.commentVisibility = commentVisibility;
            return this;
        }

        public GeneralConfigurationsBuilder contactAdministratorsMessage(String contactAdministratorsMessage) {
            this.contactAdministratorsMessage = contactAdministratorsMessage;
            return this;
        }

        public GeneralConfigurationsBuilder criteriaAutoUpdate(Boolean criteriaAutoUpdate) {
            this.criteriaAutoUpdate = criteriaAutoUpdate;
            return this;
        }

        public GeneralConfigurationsBuilder csvExportDialogDisabled(Boolean csvExportDialogDisabled) {
            this.csvExportDialogDisabled = csvExportDialogDisabled;
            return this;
        }

        public GeneralConfigurationsBuilder customFieldHtmlEnabled(Boolean customFieldHtmlEnabled) {
            this.customFieldHtmlEnabled = customFieldHtmlEnabled;
            return this;
        }

        public GeneralConfigurationsBuilder defaultLocale(String defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public GeneralConfigurationsBuilder defaultTimezone(String defaultTimezone) {
            this.defaultTimezone = defaultTimezone;
            return this;
        }

        public GeneralConfigurationsBuilder emailFromHeaderFormat(String emailFromHeaderFormat) {
            this.emailFromHeaderFormat = emailFromHeaderFormat;
            return this;
        }

        public GeneralConfigurationsBuilder emailVisibility(String emailVisibility) {
            this.emailVisibility = emailVisibility;
            return this;
        }

        public GeneralConfigurationsBuilder emptyJqlReturnsNoDataEnabled(Boolean emptyJqlReturnsNoDataEnabled) {
            this.emptyJqlReturnsNoDataEnabled = emptyJqlReturnsNoDataEnabled;
            return this;
        }

        public GeneralConfigurationsBuilder excludePrecedenceHeader(Boolean excludePrecedenceHeader) {
            this.excludePrecedenceHeader = excludePrecedenceHeader;
            return this;
        }

        public GeneralConfigurationsBuilder externalUserManagement(Boolean externalUserManagement) {
            this.externalUserManagement = externalUserManagement;
            return this;
        }

        public GeneralConfigurationsBuilder favouriteFiltersGadgetMaxTimeout(String favouriteFiltersGadgetMaxTimeout) {
            this.favouriteFiltersGadgetMaxTimeout = favouriteFiltersGadgetMaxTimeout;
            return this;
        }

        public GeneralConfigurationsBuilder globalSharing(Boolean globalSharing) {
            this.globalSharing = globalSharing;
            return this;
        }

        public GeneralConfigurationsBuilder ieMimeSniffer(String ieMimeSniffer) {
            this.ieMimeSniffer = ieMimeSniffer;
            return this;
        }

        public GeneralConfigurationsBuilder indexingLanguage(String indexingLanguage) {
            this.indexingLanguage = indexingLanguage;
            return this;
        }

        public GeneralConfigurationsBuilder inlineEdit(Boolean inlineEdit) {
            this.inlineEdit = inlineEdit;
            return this;
        }

        public GeneralConfigurationsBuilder introduction(String introduction) {
            this.introduction = introduction;
            return this;
        }

        public GeneralConfigurationsBuilder issueCommentReactionsEnabled(Boolean issueCommentReactionsEnabled) {
            this.issueCommentReactionsEnabled = issueCommentReactionsEnabled;
            return this;
        }

        public GeneralConfigurationsBuilder issuePicker(Boolean issuePicker) {
            this.issuePicker = issuePicker;
            return this;
        }

        public GeneralConfigurationsBuilder jqlAutocomplete(Boolean jqlAutocomplete) {
            this.jqlAutocomplete = jqlAutocomplete;
            return this;
        }

        public GeneralConfigurationsBuilder logoutConfirm(String logoutConfirm) {
            this.logoutConfirm = logoutConfirm;
            return this;
        }

        public GeneralConfigurationsBuilder maxAuthenticationAttempts(String maxAuthenticationAttempts) {
            this.maxAuthenticationAttempts = maxAuthenticationAttempts;
            return this;
        }

        public GeneralConfigurationsBuilder maximumLengthProjectKeys(String maximumLengthProjectKeys) {
            this.maximumLengthProjectKeys = maximumLengthProjectKeys;
            return this;
        }

        public GeneralConfigurationsBuilder maximumLengthProjectNames(String maximumLengthProjectNames) {
            this.maximumLengthProjectNames = maximumLengthProjectNames;
            return this;
        }

        public GeneralConfigurationsBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public GeneralConfigurationsBuilder projectDescriptionHtmlEnabled(Boolean projectDescriptionHtmlEnabled) {
            this.projectDescriptionHtmlEnabled = projectDescriptionHtmlEnabled;
            return this;
        }

        public GeneralConfigurationsBuilder showContactAdministratorsForm(Boolean showContactAdministratorsForm) {
            this.showContactAdministratorsForm = showContactAdministratorsForm;
            return this;
        }

        public GeneralConfigurationsBuilder stackTraceEnabled(Boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public GeneralConfigurationsBuilder title(String title) {
            this.title = title;
            return this;
        }

        public GeneralConfigurationsBuilder useGZip(Boolean useGZip) {
            this.useGZip = useGZip;
            return this;
        }

        public GeneralConfigurationsBuilder vote(Boolean vote) {
            this.vote = vote;
            return this;
        }

        public GeneralConfigurationsBuilder watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public GeneralConfigurationsBuilder xsrfDialogDisplayParamsEnabled(Boolean xsrfDialogDisplayParamsEnabled) {
            this.xsrfDialogDisplayParamsEnabled = xsrfDialogDisplayParamsEnabled;
            return this;
        }

        public GeneralConfigurations build() {
            return new GeneralConfigurations(this);
        }
    }
}

