/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;

public class UserSearchIssueContext {
    @Nonnull
    @NotEmpty
    private final List<Project> projects;
    @Nullable
    private final Issue issue;

    private UserSearchIssueContext(@Nonnull List<Project> projects, @Nullable Issue issue) {
        this.projects = Objects.requireNonNull(projects);
        this.issue = issue;
    }

    public static UserSearchIssueContext create(@Nonnull Issue issue) {
        Objects.requireNonNull(issue.getProjectObject(), () -> String.format("Project for issue: %s is null", issue));
        return new UserSearchIssueContext(Collections.singletonList(issue.getProjectObject()), issue);
    }

    public static UserSearchIssueContext createForNewIssue(@Nonnull Project project) {
        return UserSearchIssueContext.createForNewIssue((Collection<Project>)ImmutableSet.of((Object)project));
    }

    public static UserSearchIssueContext createForNewIssue(@Nonnull Collection<Project> projects) {
        Objects.requireNonNull(projects, "Projects cannot be null");
        Preconditions.checkArgument((!projects.isEmpty() ? 1 : 0) != 0, (Object)"Projects cannot be empty");
        return new UserSearchIssueContext((List<Project>)ImmutableList.copyOf(projects), null);
    }

    public Optional<Long> getIssueId() {
        return Optional.ofNullable(this.issue).map(Issue::getId);
    }

    @Nonnull
    public Long getProjectId() {
        return this.projects.stream().map(Project::getId).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    @Nonnull
    public Set<Long> getProjectIds() {
        return this.projects.stream().map(Project::getId).collect(Collectors.toSet());
    }

    public Optional<Issue> getIssue() {
        return Optional.ofNullable(this.issue);
    }

    @Nonnull
    public Project getProject() {
        return (Project)this.projects.stream().findFirst().orElseThrow(IllegalArgumentException::new);
    }

    @Nonnull
    @NotEmpty
    public List<Project> getProjects() {
        return this.projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearchIssueContext that = (UserSearchIssueContext)o;
        return Objects.equals(this.projects, that.projects) && Objects.equals(this.issue, that.issue);
    }

    public int hashCode() {
        return Objects.hash(this.projects, this.issue);
    }
}

