/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class MutableProjectComponent
implements ProjectComponent {
    private Long id;
    private String name;
    private String lead;
    private String description;
    private Long projectId;
    private long assigneeType;
    private boolean archived;
    private GenericValue genericValue;

    @Deprecated
    public MutableProjectComponent(Long id, String name, String description, String lead, long assigneeType, Long projectId) {
        this(id, name, description, lead, assigneeType, projectId, false);
    }

    public MutableProjectComponent(Long id, String name, String description, String lead, long assigneeType, Long projectId, boolean archived) {
        this.id = id;
        this.setDescription(description);
        this.lead = lead;
        this.name = name;
        this.projectId = projectId;
        this.assigneeType = assigneeType;
        this.archived = archived;
    }

    public static MutableProjectComponent copy(ProjectComponent c) {
        MutableProjectComponent mutableProjectComponent = new MutableProjectComponent(c.getId(), c.getName(), c.getDescription(), c.getLead(), c.getAssigneeType(), c.getProjectId(), c.isArchived());
        mutableProjectComponent.setGenericValue(c.getGenericValue());
        return mutableProjectComponent;
    }

    public static Collection<MutableProjectComponent> copy(Collection<ProjectComponent> c) {
        if (c == null) {
            return Collections.emptyList();
        }
        return c.stream().map(MutableProjectComponent::copy).collect(Collectors.toList());
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = TextUtils.stringSet((String)description) ? description : null;
    }

    @Override
    public String getLead() {
        return this.lead;
    }

    @Override
    public ApplicationUser getComponentLead() {
        return ComponentAccessor.getUserManager().getUserByKey(this.getLead());
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MutableProjectComponent)) {
            return false;
        }
        Long thatId = ((MutableProjectComponent)o).getId();
        return thatId != null && thatId.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MutableProjectComponent { name='");
        sb.append(this.name);
        sb.append("', description='");
        sb.append(this.description == null ? "" : this.description);
        sb.append("'");
        sb.append(", lead='");
        sb.append(this.lead == null ? "" : this.lead);
        sb.append(", assigneeType='").append(this.assigneeType);
        sb.append(", archived='").append(this.archived);
        sb.append("' }");
        return sb.toString();
    }

    public boolean equalsName(MutableProjectComponent component) {
        return this.getName().equalsIgnoreCase(component.getName());
    }

    @Override
    public long getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(long assigneeType) {
        this.assigneeType = assigneeType;
    }

    void setGenericValue(GenericValue genericValue) {
        this.genericValue = genericValue;
    }

    @Override
    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    @Override
    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }
}

