/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.SingleValueOperand;

public class VersionIndexedInputHelper
extends DefaultIndexedInputHelper<Version> {
    private final NameResolver<Version> versionResolver;

    public VersionIndexedInputHelper(IndexInfoResolver<Version> versionIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, NameResolver<Version> versionResolver) {
        super(versionIndexInfoResolver, operandResolver, fieldFlagOperandRegistry);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    @Deprecated
    public VersionIndexedInputHelper(IndexInfoResolver<Version> versionIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<Version> versionResolver) {
        this(versionIndexInfoResolver, operandResolver, fieldFlagOperandRegistry, versionResolver);
    }

    @Override
    protected SingleValueOperand createSingleValueOperandFromId(String stringValue) {
        long versionId;
        try {
            versionId = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            return new SingleValueOperand(stringValue);
        }
        Version version = this.versionResolver.get(versionId);
        if (version != null) {
            return new SingleValueOperand(version.getName());
        }
        return new SingleValueOperand(versionId);
    }
}

