/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenTabId;
import com.google.common.base.Preconditions;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.builder.ToStringBuilder;

@ExperimentalApi
@ParametersAreNonnullByDefault
public class FieldScreenLayoutItemId {
    private final FieldScreenTabId tabId;
    private final String fieldId;

    private FieldScreenLayoutItemId(FieldScreenTabId tabId, String fieldId) {
        this.tabId = (FieldScreenTabId)Preconditions.checkNotNull((Object)tabId);
        this.fieldId = (String)Preconditions.checkNotNull((Object)fieldId);
    }

    public static FieldScreenLayoutItemId byIds(FieldScreenTabId tabId, String fieldId) {
        return new FieldScreenLayoutItemId(tabId, fieldId);
    }

    public FieldScreenTabId getTabId() {
        return this.tabId;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldScreenLayoutItemId that = (FieldScreenLayoutItemId)o;
        if (!this.tabId.equals(that.tabId)) {
            return false;
        }
        return this.fieldId.equals(that.fieldId);
    }

    public int hashCode() {
        int result = this.tabId.hashCode();
        result = 31 * result + this.fieldId.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("tabId", (Object)this.tabId).append("fieldId", (Object)this.fieldId).toString();
    }
}

