/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.issue.label.Label;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LabelParser {
    public static final int MAX_LABEL_LENGTH = 255;
    public static final Pattern INVALID_PATTERN = Pattern.compile("[ ]");
    private static final String REPLACEMENT = "_";

    public static boolean isValidLabelName(String name) {
        return !INVALID_PATTERN.matcher(name).find();
    }

    public static String getCleanLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return null;
        }
        String cleanLabel = label.trim();
        cleanLabel = INVALID_PATTERN.matcher(cleanLabel).replaceAll(REPLACEMENT);
        cleanLabel = cleanLabel.substring(0, Math.min(255, cleanLabel.length()));
        return cleanLabel;
    }

    public static Set<Label> buildFromString(String labelsString) {
        return LabelParser.buildFromString(new StringToLabel(), labelsString);
    }

    public static <Y> Set<Y> buildFromString(CreateFromString<Y> factory, String labelsString) {
        if (StringUtils.isBlank((CharSequence)labelsString)) {
            return Collections.emptySet();
        }
        String[] labelArray = StringUtils.split((String)labelsString, (String)" ");
        LinkedHashSet<Y> labels = new LinkedHashSet<Y>();
        for (String label : labelArray) {
            String cleanLabel = LabelParser.getCleanLabel(label);
            if (cleanLabel == null) continue;
            labels.add(factory.create(cleanLabel));
        }
        return labels;
    }

    static class StringToLabel
    implements CreateFromString<Label> {
        StringToLabel() {
        }

        @Override
        public Label create(String labelName) {
            return new Label(null, null, null, labelName);
        }
    }

    public static interface CreateFromString<T> {
        public T create(String var1);
    }
}

