/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.JqlSearchVersionEvent;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.jql.validator.VersionValuesExistValidator;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

abstract class AbstractVersionValidator
implements ClauseValidator {
    private final Set<Operator> LIKE_OPERATORS = Collections.unmodifiableSet(EnumSet.of(Operator.LIKE, Operator.NOT_LIKE));
    private final ValuesExistValidator versionValuesExistValidator;
    private final ValuesExistValidator versionValuesExistForLikeOperatorsValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator = this.getSupportedOperatorsValidator();

    AbstractVersionValidator(VersionResolver versionResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        this.versionValuesExistValidator = this.getVersionValuesExistValidator(versionResolver, operandResolver, permissionManager, versionManager, beanFactory);
        this.versionValuesExistForLikeOperatorsValidator = this.getVersionValuesExistForLikeOperatorsValidator(versionResolver, operandResolver, permissionManager, versionManager, beanFactory);
    }

    @Override
    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        ValuesExistValidator valuesExistValidator = this.LIKE_OPERATORS.contains((Object)terminalClause.getOperator()) ? this.versionValuesExistForLikeOperatorsValidator : this.versionValuesExistValidator;
        return valuesExistValidator.validate(searcher, terminalClause);
    }

    public MessageSet validate(TerminalClause terminalClause, QueryCreationContext queryCreationContext) {
        MessageSet errors = this.supportedOperatorsValidator.validate(queryCreationContext.getApplicationUser(), terminalClause);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        ValuesExistValidator valuesExistValidator = this.LIKE_OPERATORS.contains((Object)terminalClause.getOperator()) ? this.versionValuesExistForLikeOperatorsValidator : this.versionValuesExistValidator;
        String operatorName = terminalClause.getOperator() != null ? terminalClause.getOperator().name() : "N/A";
        this.getEventPublisher().publish((Object)new JqlSearchVersionEvent(terminalClause.getName(), operatorName));
        return valuesExistValidator.validate(terminalClause, queryCreationContext);
    }

    protected EventPublisher getEventPublisher() {
        return ComponentAccessor.getComponent(EventPublisher.class);
    }

    @VisibleForTesting
    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS, OperatorClasses.TEXT_OPERATORS);
    }

    @VisibleForTesting
    VersionValuesExistValidator getVersionValuesExistValidator(VersionResolver versionResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        return new VersionValuesExistValidator(operandResolver, new VersionIndexInfoResolver(versionResolver), permissionManager, versionManager, beanFactory);
    }

    @VisibleForTesting
    VersionValuesExistValidator getVersionValuesExistForLikeOperatorsValidator(VersionResolver versionResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        return new VersionValuesExistValidator(operandResolver, new VersionIndexInfoResolver(versionResolver, versionResolver::getIdsFromNameWildcard), permissionManager, versionManager, beanFactory);
    }
}

