/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalSpi
public class UserAnonymizationParameter
implements TaskContextAware {
    private final String userKey;
    private final Context context;

    public UserAnonymizationParameter(@Nonnull String userKey, @Nonnull Context context) {
        this.userKey = Objects.requireNonNull(userKey);
        this.context = Objects.requireNonNull(context);
    }

    public UserAnonymizationParameter(@Nonnull String userKey) {
        this(userKey, Contexts.nullContext());
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    @Nonnull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAnonymizationParameter that = (UserAnonymizationParameter)o;
        return Objects.equals(this.userKey, that.userKey) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.context);
    }

    public String toString() {
        return "UserAnonymizationParameter{userKey='" + this.userKey + '\'' + ", context=" + this.context + '}';
    }
}

