/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import javax.annotation.Nonnull;

@ExperimentalApi
public interface ArchivedIssueService {
    public ArchivingResult archiveIssue(ValidationResult var1);

    public ArchivingResult restoreIssue(ValidationResult var1);

    public ValidationResult validateArchiveIssue(ApplicationUser var1, String var2);

    public ValidationResult validateRestoreIssue(ApplicationUser var1, String var2);

    public static class ValidationResult
    extends ServiceResultImpl {
        private final String issueKey;
        private final Issue issue;
        private final ApplicationUser user;

        public ValidationResult(ErrorCollection errorCollection, String issueKey) {
            super(errorCollection);
            this.issueKey = issueKey;
            this.issue = null;
            this.user = null;
        }

        public ValidationResult(ErrorCollection errorCollection, @Nonnull Issue issue) {
            this(errorCollection, issue, null);
        }

        public ValidationResult(ErrorCollection errorCollection, @Nonnull Issue issue, ApplicationUser user) {
            super(errorCollection);
            this.issueKey = issue.getKey();
            this.issue = issue;
            this.user = user;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public ApplicationUser getUser() {
            return this.user;
        }
    }

    public static class ArchivingResult
    extends ValidationResult {
        public ArchivingResult(ErrorCollection errorCollection, @Nonnull Issue issue) {
            super(errorCollection, issue);
        }
    }
}

