/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.Permissions;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class ProjectPermissionKey {
    private final String permissionKey;

    @Deprecated
    public ProjectPermissionKey(int permissionId) {
        this(ProjectPermissionKey.resolve(permissionId));
    }

    public ProjectPermissionKey(@Nonnull String permissionKey) {
        this.permissionKey = (String)Preconditions.checkNotNull((Object)permissionKey);
    }

    public String permissionKey() {
        return this.permissionKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionKey that = (ProjectPermissionKey)o;
        return this.permissionKey.equals(that.permissionKey);
    }

    public int hashCode() {
        return this.permissionKey != null ? this.permissionKey.hashCode() : 0;
    }

    public String toString() {
        return this.permissionKey;
    }

    private static String resolve(Integer permissionId) {
        String name = Permissions.getShortName(permissionId);
        ProjectPermissionKey key = ProjectPermissions.systemProjectPermissionKeyByShortName(name);
        if (key == null) {
            throw new IllegalArgumentException("No permission for id : " + permissionId + " in system");
        }
        return key.permissionKey();
    }
}

