/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.AbstractRangeQueryFactory;
import com.atlassian.jira.util.Function;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class RangeQueryFactory<T>
extends AbstractRangeQueryFactory<T, BytesRef> {
    public static RangeQueryFactory<String> stringRangeQueryFactory() {
        return new RangeQueryFactory<String>(BytesRef::new);
    }

    public RangeQueryFactory(Function<T, BytesRef> valueFactory) {
        super(valueFactory);
    }

    @Override
    Query handleLessThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, (BytesRef)this.valueFactory.apply(value), true, false);
    }

    @Override
    Query handleLessThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, (BytesRef)this.valueFactory.apply(value), true, true);
    }

    @Override
    Query handleGreaterThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, (BytesRef)this.valueFactory.apply(value), null, false, true);
    }

    @Override
    Query handleGreaterThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, (BytesRef)this.valueFactory.apply(value), null, true, true);
    }

    @Override
    Query handleDuring(String fieldName, T lowerValue, T upperValue) {
        return new TermRangeQuery(fieldName, (BytesRef)this.valueFactory.apply(lowerValue), (BytesRef)this.valueFactory.apply(upperValue), true, true);
    }
}

