/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractDateSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import webwork.action.Action;

@Internal
public class DateCustomFieldSearchRenderer
extends AbstractDateSearchRenderer
implements SearchRenderer {
    private final boolean dateTimePicker;
    private final CustomField customField;
    private final FieldVisibilityManager fieldVisibilityManager;

    public DateCustomFieldSearchRenderer(boolean isDateTimePicker, CustomField customField, SimpleFieldSearchConstants constants, DateSearcherConfig config, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, CalendarLanguageUtil calendarUtils, FieldVisibilityManager fieldVisibilityManager) {
        super(constants, config, new CustomFieldTranslationsHelper(customField), velocityRequestContextFactory, applicationProperties, templatingEngine, null, calendarUtils);
        this.dateTimePicker = isDateTimePicker;
        this.customField = customField;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    protected Map<String, Object> getVelocityParams(ApplicationUser user, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> map = super.getVelocityParams(user, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        if (this.dateTimePicker) {
            map.put("dateTimePicker", Boolean.TRUE);
        }
        return map;
    }

    @Override
    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return CustomFieldUtils.isShownAndVisible(this.customField, user, searchContext, this.fieldVisibilityManager);
    }

    private static final class CustomFieldTranslationsHelper
    implements AbstractDateSearchRenderer.TranslationsHelper {
        private final CustomField field;

        public CustomFieldTranslationsHelper(CustomField field) {
            this.field = field;
        }

        @Override
        public String getBeforeLabel(I18nHelper helper) {
            return this.field.getName() + " (" + StringUtils.lowerCase((String)helper.getText("navigator.filter.cf.before")) + ")";
        }

        @Override
        public String getAfterLabel(I18nHelper helper) {
            return this.field.getName() + " (" + StringUtils.lowerCase((String)helper.getText("navigator.filter.cf.after")) + ")";
        }

        @Override
        public String getPeriodLabel(I18nHelper helper) {
            return this.field.getName();
        }

        @Override
        public String getDescription(I18nHelper helper) {
            return this.field != null ? this.field.getDescriptionProperty().getViewHtml() : "";
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

