/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.ConvertTemporaryAttachmentParams;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class ConvertTemporaryAttachmentParamsBuilder {
    @Nullable
    private ApplicationUser author;
    private Issue issue;
    private TemporaryAttachmentId temporaryAttachmentId;
    private String filename;
    private String contentType;
    private long fileSize;
    private DateTime createdTime = DateTime.now();

    public ConvertTemporaryAttachmentParamsBuilder setAuthor(@Nullable ApplicationUser author) {
        this.author = author;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setIssue(Issue issue) {
        this.issue = issue;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setTemporaryAttachmentId(TemporaryAttachmentId temporaryAttachmentId) {
        this.temporaryAttachmentId = temporaryAttachmentId;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public ConvertTemporaryAttachmentParamsBuilder setCreatedTime(DateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public ConvertTemporaryAttachmentParams build() {
        Preconditions.checkNotNull((Object)this.issue);
        Preconditions.checkNotNull((Object)this.temporaryAttachmentId);
        Preconditions.checkNotNull((Object)this.filename);
        Preconditions.checkNotNull((Object)this.contentType);
        Preconditions.checkNotNull((Object)this.fileSize);
        Preconditions.checkNotNull((Object)this.createdTime);
        return new ConvertTemporaryAttachmentParams(this.author, this.issue, this.temporaryAttachmentId, this.filename, this.contentType, this.fileSize, this.createdTime);
    }
}

