/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@PublicApi
public interface MentionService {
    public void sendCommentMentions(ApplicationUser var1, Set<NotificationRecipient> var2, Comment var3, Comment var4);

    public void sendIssueCreateMentions(ApplicationUser var1, Set<NotificationRecipient> var2, Issue var3);

    public void sendIssueEditMentions(ApplicationUser var1, Set<NotificationRecipient> var2, Issue var3, Comment var4);

    public boolean isUserAbleToMention(ApplicationUser var1);

    @ExperimentalApi
    @Nonnull
    public Mentions getMentionedUsers(@Nonnull IssueEvent var1);

    @ExperimentalApi
    @Immutable
    public static class Mentions {
        private final Set<ApplicationUser> issueDescriptionMentions;
        private final Set<ApplicationUser> issueCommentMentions;

        public Mentions(@Nonnull Set<ApplicationUser> issueDescriptionMentions, @Nonnull Set<ApplicationUser> issueCommentMentions) {
            this.issueDescriptionMentions = Collections.unmodifiableSet(issueDescriptionMentions);
            this.issueCommentMentions = Collections.unmodifiableSet(issueCommentMentions);
        }

        @Nonnull
        public Set<ApplicationUser> getIssueDescriptionMentions() {
            return this.issueDescriptionMentions;
        }

        @Nonnull
        public Set<ApplicationUser> getIssueCommentMentions() {
            return this.issueCommentMentions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mentions mentions = (Mentions)o;
            return Objects.equals(this.issueDescriptionMentions, mentions.issueDescriptionMentions) && Objects.equals(this.issueCommentMentions, mentions.issueCommentMentions);
        }

        public int hashCode() {
            return Objects.hash(this.issueDescriptionMentions, this.issueCommentMentions);
        }
    }
}

