/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractActualValueOperatorQueryFactory {
    private final IndexValueConverter indexValueConverter;

    public AbstractActualValueOperatorQueryFactory(IndexValueConverter indexValueConverter) {
        this.indexValueConverter = Assertions.notNull("indexValueConverter", indexValueConverter);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) {
                values.add(null);
                continue;
            }
            String indexValue = this.indexValueConverter.convertToIndexValue(rawValue);
            if (indexValue == null) continue;
            values.add(indexValue);
        }
        return values;
    }
}

